import { Table } from '@/components/Elements';
import { AgencyRatingList, useRatingList } from '../../api/getRatingList';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import moment from 'moment';
export const RatingList = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, isLoading, isFetching } = useRatingList({});

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<AgencyRatingList>
          page={parseInt(page)}
          changePage={changePage}
          data={data?.data ?? []}
          total={data?.total ?? 1}
          columns={[
            { title: 'Customer Name', field: 'customer_name' },
            {
              title: 'Date',
              field: 'rating_date',
              Cell({ entry: { rating_date } }) {
                const date = moment(rating_date).format('DD-MMMM-YYYY');
                return date;
              },
            },
            { title: 'Reviews', field: 'reviews' },
            {
              title: 'Rating',
              field: 'rating',
              Cell({ entry: { rating } }) {
                return (
                  <>
                    {[...new Array(rating)].map((item, index) => {
                      return <i className="fa-solid fa-star"></i>;
                    })}
                    {[...new Array(5 - rating)].map((item, index) => {
                      return <i className="fa-regular fa-star"></i>;
                    })}
                  </>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};
