import Footer from '@/components/Layout/Footer/Footer';
import React, { useEffect, useState } from 'react';
import { useNavigate, useParams } from 'react-router-dom';
import '../../../user/SubscriptionType/st.css';
import card2 from '@/assets/card2.png';
import card5 from '@/assets/card5.png';
import 'react-responsive-modal/styles.css';
import PayPalButton from '@/components/Payments/Paypal/PayPalButton';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { paypalApi } from '../../api/Subscription/paypalApi';

export const SubScriptionPayment = () => {
  const { id } = useParams();
  const navigate = useNavigate();

  const [isLoading, setIsLoading] = useState(false);
  const [paypalData, setPaypalData] = useState('');

  const handleSubmit = async () => {
    setIsLoading(true);
    try {
      const data = await paypalApi(id ?? '1');
      console.log(data);
      setPaypalData(data?.payment_url);
    } finally {
      setIsLoading(false);
    }
  };

  useEffect(() => {
    if (paypalData != '') {
      window.open(paypalData);
    }
  }, [paypalData]);

  return (
    <>
      <BackdropLoader open={isLoading} />

      <section className="container pays mb-5 mt-3">
        <div className="payment-Methods">
          <h3 className="mb-5 mt-5">Select payment method</h3>
          <div className="row">
            <div
              role="button"
              className="col-md-3 col-4 outer-card"
              onClick={() => navigate(`/agency/subscription-payment/${id}`)}
            >
              <div className="card-box">
                <img src={card5} alt="Stripe-Card" />
              </div>
            </div>
            <div role="button" className="col-md-3 col-4 outer-card" onClick={() => handleSubmit()}>
              <div className="card-box">
                <img src={card2} alt="Paypal-Card" />
              </div>
            </div>
          </div>
        </div>
      </section>
      <Footer />
    </>
  );
};
