import React from 'react';
import { AdminLayout } from '@/components/Layout';
import SubscriptionItem from './SubscriptionItem';
import { Button } from '@/components/Elements';
import './Subscription.css';
import { useNavigate } from 'react-router-dom';

import SubscriptionLoader from '@/components/Elements/Loader/SubscriptionLoader';
import { useAgencySubScription } from '../../api/Subscription/getAgencySubScription';

export const SubscriptionAgency = () => {
  const navigate = useNavigate();
  const { data: listing, isLoading, isFetching } = useAgencySubScription({ page: '1' });
  const count: number = listing?.length ?? 0;

  return (
    <>
      <AdminLayout title="Agency Subscription Management">
        {isLoading || isFetching ? (
          <SubscriptionLoader />
        ) : (
          <>
            <div className="add-btn-sub">
              {count >= 3 ? null : (
                <>
                  <Button
                    onClick={() => {
                      navigate('/admin/agency-add-subscription');
                    }}
                  >
                    + Add
                  </Button>
                </>
              )}
            </div>

            <div className="row">
              {listing?.slice(0, 4).map((item, index) => (
                <SubscriptionItem item={item} key={index} />
              ))}
            </div>
          </>
        )}
      </AdminLayout>
    </>
  );
};
