import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import { useAuth } from '@/lib/auth';
import { useAgencySubScription } from '../../api/Subscription/getAgencySubScription';
import { Button } from '@/components/Elements';
import { useState } from 'react';
import { buyBasicPlan } from '../../api/Subscription/buyBasicPlan';
import { CurrentPlan, useMyPlan } from '../../api/Subscription/getMyPlan';
import storage from '@/utils/storage';
import { postSubscriptionBasicAgency } from '@/api/SubscriptionCustomer/postSubscriptionBasic';

export const SubscriptionType = () => {
  const { data: listing, isLoading } = useAgencySubScription({ page: '1' });
  const { data, isFetching, isLoading: load } = useMyPlan();
  const planId = (data && data.data && data.data.length > 0) ? data.data[0].plan_id : null;

  const auth = useAuth();
  const [loading, setLoading] = useState<boolean>(false);

  const navigate = useNavigate();

  const changeStatusAction = async (id: string, price: any) => {
    // try {
    //   useNotificationStore.getState().addNotification({
    //     title: 'Success',
    //     type: 'success',
    //     message: 'You have selected the subscription successfully',
    //   });
    // } finally {
    //   navigate(`/agency/subscription-select-payment/${id}`);
    // }

    try {
      if (price == '0') {
        await postSubscriptionBasicAgency(id);
        useNotificationStore.getState().addNotification({
          title: 'Success',
          type: 'success',
          message: 'You have selected the subscription successfully',
        });
        navigate('/user/profile');
      } else {
        useNotificationStore.getState().addNotification({
          title: 'Success',
          type: 'success',
          message: 'You have selected the subscription successfully',
        });
        navigate(`/agency/subscription-select-payment/${id}`);
      }
    } finally {
      console.log('');
    }
  };

  const handleSubmit = async (planId: string) => {
    setLoading(true);
    try {
      await buyBasicPlan(planId);
      setLoading(false);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have selected the subscription successfully',
      });
      navigate('/agency/profile');
    } finally {
      setLoading(false);
    }
  };
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  return (
    <>
      <section className="container ">
        <section className="cardsd container grid">
          <div className="card__container grid">
            {isLoading || isFetching || load ? (
              <MyListingLoader />
            ) : (
              <>
                <div className="row subscription-row">
                  {listing?.map((item, index) => {
                    const myPlan: Array<CurrentPlan> = listing.filter((i) => i.id === planId);
                    console.log(myPlan);
                    return (
                      <div className="col-md-4 cfd" key={index}>
                        <article className="card__content grid">
                          <header className="card__header">
                            <div className="row">
                              <div className="col-md-8 col-sm-4">
                                <h1 className="card__header-title">{item.plan_name}</h1>
                              </div>
                              <div className="col-md-4 col-sm-4">
                                <span className="card__header-subtitle">
                                  {localSymbol}{' '}
                                  {(parseFloat(item?.price) * localCurrency)?.toFixed(0) ?? ''}
                                </span>
                              </div>
                            </div>
                          </header>
                          <hr />
                          <div className="sub-descript">
                            <p className="card_Description">{item.plan_description}</p>
                            <hr className="zInd" />
                          </div>

                          {auth.user?.has_subscription == true ? (
                            myPlan[0]?.id === item?.id ? (
                              <>
                                <Button
                                  variant="outline"
                                  disabled={true}
                                  onClick={() => changeStatusAction(item.id, item.price)}
                                  className="card__button"
                                >
                                  Subscribed
                                </Button>
                              </>
                            ) : myPlan[0]?.plan_name === 'Premium' ? (
                              <>
                                <Button
                                  variant="outline"
                                  disabled={true}
                                  onClick={() => changeStatusAction(item.id, item.price)}
                                  className="card__button"
                                >
                                  Upgrade Plan
                                </Button>
                              </>
                            ) : (
                              <>
                                <Button
                                  variant="outline"
                                  onClick={() => changeStatusAction(item.id, item.price)}
                                  className="card__button"
                                >
                                  Upgrade Plan
                                </Button>
                              </>
                            )
                          ) : (
                            <>
                              {item?.price === '0' ? (
                                <Button
                                  variant="outline"
                                  isLoading={loading}
                                  onClick={() => handleSubmit(item.id)}
                                  className="card__button"
                                >
                                  Subscribe plan
                                </Button>
                              ) : (
                                <Button
                                  variant="outline"
                                  onClick={() => changeStatusAction(item.id, item.price)}
                                  className="card__button"
                                >
                                  Subscribe plan
                                </Button>
                              )}
                            </>
                          )}
                        </article>
                      </div>
                    );
                  })}
                </div>
              </>
            )}
          </div>
        </section>
      </section>
    </>
  );
};
