import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { AxiosResponse } from 'axios';
import { useQuery } from 'react-query';

export type AgencyData = {
  first_name: string;
  last_name: string;
  agency_company: string;
  email: string;
  is_active: boolean;
  profile_image: string;
  role: string;
  isProfileCompleted: boolean;
  phoneVerified: boolean;
  customer_id: string;
  has_subscription: boolean;
  subscription_id: string;
  phone_number: string;
  user_type: string;
  your_self: string;
  past_experience: string;
  latitude: number;
  longitude: number;
  address: string;
};

export const getAgencyProfile = (): Promise<AxiosResponse<AgencyData>> => {
  return axios.get('/agency-api/agnecy-complete-profile');
};

type QueryFnType = typeof getAgencyProfile;

type useAgency = {
  config?: QueryConfig<QueryFnType>;
};

export const useAgencyProfileData = ({ config }: useAgency = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agencydata'],
    queryFn: getAgencyProfile,
  });
};
