import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { ApiResponse, User } from '@/types';

type UpdateProfileDTO = {
  profile_image: string;
  latitude: string;
  longitude: string;
  username: string;
  first_name: string;
  last_name: string;
  email: string;
  address: string;
  whatsapp_number: string;
  phone_number: string;
  twitter: string;
  facebook_url: string;
  twitter_url: string;
  instagram_url: string;
  youtube_url: string;
  linkedin_url: string;
  pintrest_url: string;
};

export const getProfile = (): Promise<ApiResponse<User>> => {
  return axios.get('customer-api/profile');
};

export const updateProfile = (payload: UpdateProfileDTO): Promise<void> => {
  return axios.post('customer-api/profile', payload);
};

type QueryFnType = typeof getProfile;

type UseProfileOptions = {
  config?: QueryConfig<QueryFnType>;
};

export const useProfile = ({ config }: UseProfileOptions = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['profile'],
    queryFn: getProfile,
  });
};
