import axios from 'axios';
import { API_URL } from '@/config';

export type VerifyDTO = {
  token: string;
};

export const emailVerifyToken = (data: VerifyDTO) => {
  return new Promise((resolve, reject) => {
    axios
      .post(`${API_URL}/auth/verify-email?token=${data.token}`)
      .then(() => {
        return resolve({ status: true });
      })
      .catch((e) => {
        return reject({ status: false, message: e.response.data.message });
      });
  });
};
