import { ROLES } from '@/lib/authorization';

export type AuthUser = {
  id: string;
  customer_id: string;
  email: string;
  first_name: string;
  last_name: string;
  profile_image: string;
  dob: string;
  address: string;
  phone: string;
  image: string;
  bio: string;
  role: ROLES;
  isProfileCompleted: boolean;
  email_verified: boolean;
  phoneVerified: boolean;
  has_subscription: boolean;
  permission: any;
  subscription_id : string;
};

export type UserResponse = {
  access: string;
  refresh: string;
  user: AuthUser;
};

export type ProfileResponse = {
  message: string;
  data: AuthUser;
};

export type RegisterResponse = {
  message: string;
  data: UserResponse;
};
