import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { Subscription } from '@/types';

export const getAgencySubId = (id: string): Promise<Subscription> => {
  return axios.get(`/subscription-api/agency-plan-details?id=${id}`);
};

type QueryFnType = typeof getAgencySubId;
type UseAgencyOptions = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useAgencySubId = ({ config, id }: UseAgencyOptions = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agency-plan-detail'],
    queryFn: () => getAgencySubId(id),
  });
};
