import { useQuery } from 'react-query';
import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { TableResponse } from '@/types/TableResponse';
import { LawyerContractList } from '../types/LawyerContractList';

export const getLawyerContract = (): Promise<TableResponse<LawyerContractList>> => {
  return axios.get('/lawyer-api/user-contract-request');
};

type QueryFnType = typeof getLawyerContract;

type UseInquiryOptions = {
  config?: QueryConfig<QueryFnType>;
};

export const useLawyerContract = ({ config }: UseInquiryOptions) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['agency-req'],
    queryFn: () => getLawyerContract(),
  });
};
