import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { InvestorContent } from '@/types/InvestorContent';
import { ApiResponse } from '@/types';

export const getpropertyDeveloper = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.get('/admin-api/property-content-page');
};

export const postProject = (): Promise<ApiResponse<InvestorContent>> => {
  return axios.post('/admin-api/property-content-page');
};

type QueryFnType = typeof getpropertyDeveloper;

type investorData = {
  config?: QueryConfig<QueryFnType>;
};

export const usePropertyDeveloper = ({ config }: investorData = {}) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['Investor'],
    queryFn: () => getpropertyDeveloper(),
  });
};
