import { axios } from '@/lib/axios';
import { LawyerContractList } from '../types/LawyerContractList';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';

export const seeContractDetails = (id: string): Promise<LawyerContractList> => {
  return axios.get(`/lawyer-api/user-contract-details?contract_id=${id}`);
};

type QueryFnType = typeof seeContractDetails;

type useContractDetails = {
  config?: QueryConfig<QueryFnType>;
  id: string;
};

export const useContractDetails = ({ config, id }: useContractDetails = { id: '1' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['lawyerContractDetails'],
    queryFn: () => seeContractDetails(id),
  });
};
