import React from 'react';
import './lawyer.css';
import { useContractDetails } from '../api/seeContractDetails';
import { useParams } from 'react-router-dom';
import TableLoader from '@/components/Elements/Loader/TableLoader';

export const LawyerContractDetails = () => {
  const { id } = useParams();

  const { data, isLoading, isFetching } = useContractDetails({ id: id ?? '' });
  const listing = data?.data;
  if (!isLoading && !isFetching) {
    console.log(listing);
  }

  return (
    <>
      {isLoading && isFetching ? (
        <TableLoader />
      ) : (
        <>
          <div className="container pt-5 px-5">
            <h3 className="text-primary mb-4">Lawyer Contract Details</h3>
          </div>

          <div>
            <div className="bg-white mt-8 mx-5 py-8 px-8 shadow sm:rounded-lg sm:px-12 h-full">
              <div className="row">
                <div className="col-12 box">
                  <div className="heading semi-bold">Contract Details</div>
                  <div className="row styling">
                    <div className="col-md-4 col-4 naam">
                      {listing.customer_email ? 'Inquiry Customer Email' : ''}
                    </div>
                    <div className="col-md-8 col-8 leftt">{listing.customer_email}</div>
                  </div>

                  <div className="row styling">
                    <div className="col-md-4 col-4 naam">
                      {listing.customer_phone_number ? 'Inquiry Customer No.' : ''}
                    </div>
                    <div className="col-md-8 col-8 leftt">{listing.customer_phone_number}</div>
                  </div>

                  <div className="row styling">
                    <div className="col-md-4 col-4 naam">
                      {listing.property_project_customer_email ? 'Property Customer Email' : ''}
                    </div>
                    <div className="col-md-8 col-8 leftt">
                      {listing.property_project_customer_email}
                    </div>
                  </div>

                  <div className="row styling">
                    <div className="col-md-4 col-4 naam">
                      {listing.property_project_customer_name ? 'Property Customer Name' : ''}
                    </div>
                    <div className="col-md-8 col-8 leftt">
                      {listing.property_project_customer_name}
                    </div>
                  </div>

                  <div className="row styling">
                    <div className="col-md-4 col-4 naam">
                      {listing.property_project_customer_phone_number
                        ? 'Property Customer No.'
                        : ''}
                    </div>
                    <div className="col-md-8 col-8 leftt">
                      {listing.property_project_customer_phone_number}
                    </div>
                  </div>

                  <div className="row styling">
                    <div className="col-md-4 col-4 naam">{listing.message ? 'Message' : ''}</div>
                    <div className="col-md-8 col-8 leftt">{listing.message}</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </>
      )}
    </>
  );
};
