import React, { useEffect } from 'react';
import { Table } from '@/components/Elements';
import TableLoader from '@/components/Elements/Loader/TableLoader';

import { useNavigate } from 'react-router-dom';
import { useLawyerContract } from '../api/getLawyerContract';
import { LawyerContractList } from '../types/LawyerContractList';

export const LawyerInquiryList = ({
  page,
  changePage,
}: {
  page: string;
  changePage: (page: string) => void;
}) => {
  const { data, refetch, isLoading, isFetching } = useLawyerContract({});

  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<LawyerContractList>
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 1}
          data={data?.data ?? []}
          columns={[
            { title: 'Inquiry Customer Name', field: 'customer_name' },
            { title: 'Inquiry Customer Email', field: 'customer_email' },
            { title: 'Inquiry Customer No.', field: 'customer_phone_number' },
            { title: 'Property Customer Name', field: 'property_project_customer_name' },
            { title: 'Property Customer No.', field: 'property_project_customer_phone_number' },
            { title: 'Property Customer Email.', field: 'property_project_customer_email' },

            {
              title: 'Action',
              field: 'id',
              Cell({ entry: { id } }) {
                return (
                  <span
                    role="button"
                    tabIndex={-1}
                    className="icon me-2"
                    title="View Details"
                    onClick={() => navigate(`/lawyer/contract-details-page/${id}`)}
                  >
                    <i className="fa-solid fa-eye"></i>
                  </span>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};
