import React, { useEffect } from 'react';
import { useUsers } from '@/api/users/getUsers';
import { Table } from '@/components/Elements';
import { User } from '@/types';
import TableLoader from '@/components/Elements/Loader/TableLoader';
import { useNavigate } from 'react-router-dom';
import i18next from 'i18next';

const UserList = ({ page, changePage }: { page: string; changePage: (page: string) => void }) => {
  const { data, refetch, isLoading, isFetching } = useUsers({ page });
  const navigate = useNavigate();

  useEffect(() => {
    refetch();
  }, [page, refetch]);

  return (
    <>
      {isLoading || isFetching ? (
        <TableLoader />
      ) : (
        <Table<User>
          page={parseInt(page)}
          changePage={changePage}
          total={data?.total ?? 0}
          data={data?.data ?? []}
          columns={[
            { title: `${i18next.t('Name')}`, field: 'first_name' },
            { title: `${i18next.t('Email')}`, field: 'email' },
            { title: `${i18next.t('Phone')}`, field: 'phone_number' },
            {
              title: 'Action',
              field: 'status',
              Cell({ entry: { id } }) {
                return (
                  <>
                    <span
                      role="button"
                      tabIndex={-1}
                      onKeyDown={() => navigate(`/admin/users/${id}`)}
                      onClick={() => navigate(`/admin/users/${id}`)}
                      className="icon me-2"
                      title="View"
                    >
                      <i className="fa-regular fa-eye" />
                    </span>
                  </>
                );
              },
            },
          ]}
        />
      )}
    </>
  );
};

export default UserList;
