import React, { useEffect, useState } from 'react';

import { AdminLayout } from '@/components/Layout';
import 'react-circular-progressbar/dist/styles.css';

import './Dashboard.css';
import building1 from '@/assets/building1.png';
import building2 from '@/assets/building2.png';
import building3 from '@/assets/building3.png';
import users from '@/assets/li5.svg';
import building4 from '@/assets/building4.png';

import FileViewer from '@/components/Viewer/FileViewer';
import { useNavigate } from 'react-router-dom';
import storage from '@/utils/storage';
import DashboardLoader from '@/components/Elements/Loader/DashboardLoader';
import ReactApexChart from 'react-apexcharts';
import { trimTwenty } from '@/utils/format';
import i18next from 'i18next';

export const Dashboard = () => {
  const navigate = useNavigate();
  const [user, setUser] = useState([]);
  const token = storage.getToken();
  const axiosUrl = process.env.REACT_APP_API_URL;

  const fetchData = () => {
    const headers = { Authorization: `${token}` };
    return fetch(`${axiosUrl}/admin-api/admin-dashboard`, { headers })
      .then((response) => response.json())
      .then((data) => setUser(data));
  };

  useEffect(() => {
    fetchData();
  }, []);

  type User = {
    id: string;
    name: string;
    title: string;
    role: string;
    email: string;
  };

  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  const data: User[] = [
    {
      id: '1',
      name: 'Jane Cooper',
      title: 'Regional Paradigm Technician',
      role: 'Admin',
      email: 'jane.cooper@example.com',
    },
    {
      id: '2',
      name: 'Cody Fisher',
      title: 'Product Directives Officer',
      role: 'Owner',
      email: 'cody.fisher@example.com',
    },
  ];

  const [chartData, setChartData] = useState<any>([]);

  useEffect(() => {
    if (user?.all_property_chart) {
      const {
        property_project_percentage,
        rent_property_percentage,
        sale_property_percentage,
        house_wanted_rent_percentage,
        bussiness_for_sale_percentage,
        investment_my_company_percentage,
      } = user?.all_property_chart;

      const data = [
        { x: 'Property Project', y: property_project_percentage },
        { x: 'Rent Property', y: rent_property_percentage },
        { x: 'Sale Property', y: sale_property_percentage },
        { x: 'House Wanted Rent', y: house_wanted_rent_percentage },
        { x: 'Business for Sale', y: bussiness_for_sale_percentage },
        { x: 'Investment My Company', y: investment_my_company_percentage },
      ];

      setChartData(data);
    }
  }, [user]);
  return (
    <>
      {user?.count_data ? (
        <AdminLayout title={i18next.t('Dashboard')}>
          <section className="dashboard-home">
            <div className="row">
              <button
                onClick={() => navigate('/property-for-sale')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.sale_property_count}</h4>
                      <h6>{i18next.t('Properties For Sale')}</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building1} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/property-for-rent')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.rent_property_count}</h4>

                      <h6>Properties For Rent</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building2} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/housing-for-rent')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.house_wanted_rent_count}</h4>

                      <h6>House Wanted Rent</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building4} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button onClick={() => null} className="outer-box col-md-3 col-6">
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.customer_count}</h4>
                      <h6>Total Customer</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building3} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
            </div>
            <div className="row">
              <button
                onClick={() => navigate('/property-project')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.property_project_count}</h4>
                      <h6>{i18next.t('Property Project')}</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building3} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('/property-Sale-Rent')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.investment_my_company_count}</h4>
                      <h6>Investment My Company</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building3} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
              <button
                onClick={() => navigate('business-for-sale')}
                className="outer-box col-md-3 col-6"
              >
                <div className="inr-box">
                  <div className="row">
                    <div className="col-8 col-md-8 left">
                      <h4>{user?.count_data?.bussiness_for_sale_count}</h4>
                      <h6>Bussiness For Sale</h6>
                    </div>
                    <div className="col-8 col-md-4 right">
                      <img src={building2} alt="pics" />
                    </div>
                  </div>
                </div>
              </button>
            </div>

            <div className="row dashbords">
              <div className="col-md-6 col-6 oUtr">
                <div className="in-boxx">
                  <div className="row">
                    <div className="das-head">Customer Data</div>
                  </div>
                  {user?.customer_data?.slice(0, 5)?.map((item, index) => (
                    <div className="row kim" key={index}>
                      <div className="col-md-2 col-2 dashboardprofile">
                        {item?.image ? (
                          <FileViewer file={item?.image ?? ''}></FileViewer>
                        ) : (
                          <FileViewer file={users}></FileViewer>
                        )}
                      </div>
                      <div className="col-md-4 col-4 naam">{item?.first_name}</div>
                      <div className="col-md-6 col-6 leftt">
                        {item?.email ? item?.email : 'N/A'}
                      </div>
                    </div>
                  ))}
                </div>
              </div>
              <div className="col-md-6 col-6 oUtr">
                <div className="in-boxx">
                  <div className="row ">
                    <div className="das-head">Recent Properties</div>

                    <div className="rect-pix">
                      {user?.recent_properties?.slice(0, 4)?.map((item, index) => (
                        <div className="row" key={index}>
                          <div className="col-4 col-md-4">
                            {item?.image && (
                              <FileViewer file={eval(item?.image)[0]?.image ?? ''}></FileViewer>
                            )}
                          </div>
                          <div className="col-8 col-md-8">
                            <p className="p1">{trimTwenty(item?.title)}</p>

                            <p className="p3">$ {item?.price}</p>
                          </div>
                        </div>
                      ))}
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="row dbs">
              <div className="outerr col-md-7 col-7">
                <div className=" rights">
                  <div>
                    <h4>Total Properties</h4>
                    {chartData ? (
                      <ReactApexChart
                        options={{
                          labels: chartData?.map((item: any) => item.x),
                          colors: [
                            '#008FFB',
                            '#00E396',
                            '#FEB019',
                            '#FF4560',
                            '#775DD0',
                            '#D3D3D3',
                          ],
                          legend: {
                            show: true,
                            position: 'bottom',
                          },
                        }}
                        series={chartData?.map((item: any) => item.y)}
                        type="donut"
                        height={350}
                      />
                    ) : null}
                  </div>
                </div>
              </div>
            </div>
          </section>
        </AdminLayout>
      ) : (
        <div className="row spins">
          <DashboardLoader />
        </div>
      )}
    </>
  );
};
