import React, { useEffect, useState } from 'react';
import { AdminLayout } from '@/components/Layout';
import { usePagination } from '@/hooks/usePagination';
import { SubscriptionType } from '../SubscriptionAgency/SubscriptionType';
import { useAuth } from '@/lib/auth';
import { LawyerInquiryList } from '../../components/LawyerInquiryList';
import TableLoader from '@/components/Elements/Loader/TableLoader';

export const Inquiries = () => {
  const [loading, setLoading] = useState<boolean>(false);

  const { page, changePage } = usePagination();
  const { user, refetchUser } = useAuth();

  useEffect(() => {
    setLoading(true);
    refetchUser();
    setTimeout(() => {
      setLoading(false);
    }, 1000);
  }, [user?.has_subscription]);

  return (
    <AdminLayout title="Lawyer Contract Request List">
      {loading && <TableLoader />}
      {!loading ? (
        user?.has_subscription === true ? (
          <LawyerInquiryList page={page} changePage={changePage} />
        ) : (
          <SubscriptionType />
        )
      ) : null}
    </AdminLayout>
  );
};
