import React from 'react';
import { AdminLayout } from '@/components/Layout';
import { useParams } from 'react-router-dom';
import { Entry } from '@/components/Elements/Table/Entry';
import { useInquiryDetails } from '@/api/inquiry/getInquiryDetails';
import InquiryDetailLoader from '@/components/Elements/Loader/InquiryDetailLoader';
import i18next from 'i18next';

export const Inquiry = () => {
  const { id } = useParams();
  const { data, isLoading, isFetching } = useInquiryDetails({ id: id ?? '1' });
  const inquiry = data?.data;

  return (
    <AdminLayout title="Inquiry Details">
      {isLoading || isFetching ? (
        <InquiryDetailLoader />
      ) : (
        <div className="row mt-2">
          <div className="col-12 mt-4">
            <Entry label={i18next.t('Name')} value={inquiry?.name ?? ''} />
            <Entry label="Telephone" value={`+${inquiry?.telephone ?? ''}`} />
            <Entry label={i18next.t('Email')} value={inquiry?.email ?? ''} />
            <Entry label={i18next.t('Message')} value={inquiry?.message ?? ''} />
            <Entry label="Property Owner Email" value={inquiry?.property_owner_email ?? ''} />
          </div>
        </div>
      )}
    </AdminLayout>
  );
};
