import React, { useState } from 'react';
import notificationType from '@/constants/notificationType';
import NotifyAll from '@/features/user/components/NotifyAll';
import './AllnotificationAgency.css';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import { ContentLayout } from '@/components/Layout';
import NotificationLoader from '@/components/Elements/Loader/NotificationLoader';
import { Button } from '@/components/Elements/Button';
import { useAgencyNotifications } from '../../api/Notification/getAgencyNotifications';
import { deleteNotificationsAgency } from '../../api/Notification/deleteNotificationsAgency';
import { readNotificationsAgency } from '../../api/Notification/readNotificationsAgency';

export const AllNotifiationsAgency = () => {
  const { data: notifications, refetch } = useAgencyNotifications();
  const [selected, setSelected] = useState<any>([]);
  const [loading, setLoading] = useState(false);
  const [count, setCount] = useState(9);

  const handleAdd = () => {
    setCount(count + 5);
  };
  const handleSub = () => {
    setCount(count - 5);
  };
  const handleSelect = (id: string) => {
    let currentSelected = [...selected];
    if (currentSelected.includes(id)) {
      currentSelected = currentSelected.filter((i) => i !== id);
    } else {
      currentSelected.push(id);
    }
    setSelected(currentSelected);
  };
  const selectAll = () => {
    if (notifications?.data?.length === selected.length) {
      setSelected([]);
      return;
    }
    const currentSelected = notifications?.data?.map((i) => i.id) ?? [];
    setSelected(currentSelected);
  };

  const deleteSelected = async () => {
    setLoading(true);
    await deleteNotificationsAgency(selected);
    refetch();
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'info',
      message: 'Notifications deleted successfully!',
    });
    setSelected([]);
    setLoading(false);
  };

  const readSelected = async () => {
    setLoading(true);
    await readNotificationsAgency(selected);
    refetch();
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'info',
      message: 'Notifications read successfully!',
    });
    setSelected([]);
    setLoading(false);
  };
  const navigate = useNavigate();

  return (
    <>
      <ContentLayout title="Admin Notifications">
        <section className="container main-notify">
          {loading ? (
            <NotificationLoader />
          ) : (
            <div className="notification-box">
              <div className="row lin">
                <div className="col-12 col-md-4 noti">Notifications</div>
                <div className="col-12 col-md-8 toper">
                  {selected.length > 0 && (
                    <>
                      <button onClick={deleteSelected}>Delete</button>
                      <button onClick={readSelected}>Read</button>
                    </>
                  )}

                  <button onClick={selectAll}>Select all</button>
                </div>
              </div>
              <div className="notifies">
                {notifications?.data?.length === 0 && <p>No new notifications found</p>}
                <ul>
                  {notifications?.data?.slice(0, count)?.map((item) => (
                    <li key={item.id}>
                      {item.notification_type === 'customer_agency_accept' && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/inquiries')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.property_project && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/property-project-listings')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.contract_created && (
                        <button
                          className="notify-navigate-button"
                          // onClick={() => navigate('/admin/')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.bussiness_sale && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/business-listings')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}

                      {item.notification_type === notificationType.new_registered && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/admin-report')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.company_registered && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/admin-report')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.complete_profile && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/profile')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}

                      {item.notification_type === notificationType.property_inquire && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/inquiries')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.contract_status && (
                        <button
                          className="notify-navigate-button"
                          // onClick={() => navigate('/admin/')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.start_contract && (
                        <button
                          className="notify-navigate-button"
                          // onClick={() => navigate('/admin/')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.contact_us && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/admin-report')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}

                      {item.notification_type === notificationType.rent_property && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/property-for-Rent')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.sale_property && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/property-Sale-Rent')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.house_rent && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/housing-listings')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.investment_project && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/project-investment-listings')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.investment_company && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/company-Investment-listings')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                      {item.notification_type === notificationType.upload_property_request && (
                        <button
                          className="notify-navigate-button"
                          onClick={() => navigate('/admin/property-listings')}
                        >
                          <NotifyAll item={item} selected={selected} onSelectItem={handleSelect} />
                        </button>
                      )}
                    </li>
                  ))}
                </ul>
              </div>
              <div className="notifyBottom row">
                {count <= 11 ? (
                  <div>
                    <Button onClick={() => handleAdd()}>Show More</Button>
                  </div>
                ) : (
                  <>
                    <div className="col-md-6">
                      {count <= 11 ? null : <Button onClick={() => handleSub()}>Show Less</Button>}
                    </div>
                    <div className="col-md-6">
                      {count >= notifications?.data?.length ? null : (
                        <Button onClick={() => handleAdd()}>Show More</Button>
                      )}
                    </div>
                  </>
                )}
              </div>
            </div>
          )}
        </section>
        <br />
      </ContentLayout>
    </>
  );
};
