import { useEffect, useState } from 'react';
import { useNavigate, useParams } from 'react-router-dom';
import '../../../user/SubscriptionType/st.css';
import card2 from '@/assets/card2.png';
import card4 from '@/assets/card4.png';
import card5 from '@/assets/card5.png';
import card6 from '@/assets/escrow.png';
import 'react-responsive-modal/styles.css';
// import UserHeadBar from '../components/UserHeadBar';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { paypalApi } from '../../api/Subscription/paypalApi';

export const SubScriptionPayment = () => {
  const { id } = useParams();
  const navigate = useNavigate();

  const [isLoading, setIsLoading] = useState(false);
  const [paypalData, setPaypalData] = useState('');

  const handleSubmit = async () => {
    setIsLoading(true);
    try {
      const data = await paypalApi(id ?? '1');
      console.log(data);
      setPaypalData(data?.payment_url);
    } finally {
      setIsLoading(false);
    }
  };

  useEffect(() => {
    if (paypalData != '') {
      window.open(paypalData);
    }
  }, [paypalData]);

  return (
    <>
      <BackdropLoader open={isLoading} />

      {/* <UserHeadBar /> */}
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <section className="container pays mb-5 mt-3">
        <div className="payment-Methods">
          <h3 className="mb-5">Select payment method</h3>
          <div className="row">
            <div
              role="button"
              className="col-md-3 col-4 outer-card"
              onClick={() => navigate(`/lawyer/subscription-payment/${id}`)}
            >
              <div className="card-box">
                <img src={card5} alt="Stripe-Card" />
              </div>
            </div>
            <div role="button" className="col-md-3 col-4 outer-card" onClick={() => handleSubmit()}>
              <div className="card-box">
                <img src={card2} alt="Paypal-Card" />
              </div>
            </div>
            <div className="col-md-3 col-4 outer-card">
              <div className="card-box">
                <img src={card4} alt="Voops-Card" />
              </div>
            </div>
            <div className="col-md-3 col-4 outer-card">
              <div className="card-box">
                <img src={card6} alt="Escrow-Card" />
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};
