import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import { useAuth } from '@/lib/auth';
import { useAgencySubScription } from '../../api/Subscription/getAgencySubScription';
import { buyBasicPlan } from '../../api/buyBasicPlan';
import { useState } from 'react';
import { Button } from '@/components/Elements';
import storage from '@/utils/storage';
import { postSubscriptionBasiclawyer } from '@/api/SubscriptionCustomer/postSubscriptionBasic';

export const SubscriptionType = () => {
  const { data: listing, isLoading } = useAgencySubScription({ page: '1' });
  const auth = useAuth();
  const subscriptionplan = auth?.user?.subscription_id;
  const navigate = useNavigate();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const [loading, setLoading] = useState<boolean>(false);

  const changeStatusAction = async (id: string, price: any) => {
    // try {
    //   useNotificationStore.getState().addNotification({
    //     title: 'Success',
    //     type: 'success',
    //     message: 'You have selected the subscription successfully',
    //   });
    // } finally {
    //   navigate(`/lawyer/subscription-select-payment/${id}`);
    // }
    try {
      if (price == '0') {
        await postSubscriptionBasiclawyer(id);
        useNotificationStore.getState().addNotification({
          title: 'Success',
          type: 'success',
          message: 'You have selected the subscription successfully',
        });
        navigate('/user/profile');
      } else {
        useNotificationStore.getState().addNotification({
          title: 'Success',
          type: 'success',
          message: 'You have selected the subscription successfully',
        });
        navigate(`/agency/subscription-select-payment/${id}`);
      }
    } finally {
      console.log('');
    }
  };

  const handleSubmit = async (planId: string) => {
    setLoading(true);
    try {
      await buyBasicPlan(planId);
      setLoading(false);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have selected the subscription successfully',
      });
      navigate('/lawyer/profile');
    } finally {
      setLoading(false);
    }
  };
  return (
    <>
      <section className="container ">
        <section className="cardsd container grid">
          <div className="card__container grid">
            {isLoading ? (
              <MyListingLoader />
            ) : (
              <>
                <div className="row subscription-row">
                  {listing?.map((item, index) => {
                    return (
                      <div className="col-md-4 cfd" key={index}>
                        <article className="card__content grid">
                          {subscriptionplan === item.id ? (
                            <>
                              <div className="card__pricing">
                                <div className="card__pricing-number">
                                  <span className="card__pricing-symbol">
                                    <i className="fa-solid fa-check-double holaj"></i>
                                  </span>
                                </div>
                              </div>
                            </>
                          ) : null}

                          <header className="card__header">
                            <div className="row">
                              <div className="col-md-8 col-sm-4">
                                <h1 className="card__header-title">{item.plan_name}</h1>
                              </div>
                              <div className="col-md-4 col-sm-4">
                                <span className="card__header-subtitle">
                                  {localSymbol}{' '}
                                  {(parseFloat(item?.price) * localCurrency)?.toFixed(0) ?? ''}
                                </span>
                              </div>
                            </div>
                          </header>
                          <hr />
                          <div className="sub-descript">
                            <p className="card_Description">{item.plan_description}</p>
                            <hr className="zInd" />
                          </div>
                          {auth.user?.has_subscription == true ? (
                            <>
                              {subscriptionplan === item.id ? (
                                <>
                                  <Button className="card__button">Subscribed</Button>
                                </>
                              ) : (
                                <>
                                  {item?.plan_name == 'Basic' ? (
                                    <Button variant="outline" disabled className="card__button">
                                      Upgrade Plan
                                    </Button>
                                  ) : (
                                    <Button
                                      variant="outline"
                                      onClick={() => changeStatusAction(item.id, item.price)}
                                      className="card__button"
                                    >
                                      Upgrade Plan
                                    </Button>
                                  )}
                                </>
                              )}
                            </>
                          ) : (
                            <>
                              {item?.price === '0' ? (
                                <Button
                                  variant="outline"
                                  isLoading={loading}
                                  className="card__button"
                                  onClick={() => handleSubmit(item.id)}
                                >
                                  Subscribe Plan
                                </Button>
                              ) : (
                                <Button
                                  variant="outline"
                                  onClick={() =>
                                    navigate(`/lawyer/subscription-select-payment/${item.id}`)
                                  }
                                  className="card__button"
                                >
                                  Subscribe Plan
                                </Button>
                              )}
                            </>
                          )}
                        </article>
                      </div>
                    );
                  })}
                </div>
              </>
            )}
          </div>
        </section>
      </section>
    </>
  );
};
