import React, { useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import house from '@/assets/house.png';
import './Contact.css';
import * as z from 'zod';
import { Button } from '@/components/Elements';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import ConstactIntrestedin from '@/constants/ConstactIntrestedin';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import { ContentLayout } from '@/components/Layout';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import { contactUS } from '@/api/countactUs';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import { InputPhone } from '@/components/Form/InputPhone';
import i18next from 'i18next';

export const Contact = () => {
  const [loading, setLoading] = useState(false);
  const [open, setOpen] = useState(false);
  const navigate = useNavigate();

  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  const schema = z.object({
    full_name: z.string().min(1, 'Please enter your full name'),
    email: z
      .string()
      .min(1, 'Please enter email address')
      .email('Please enter valid email address!'),
    phone_number: z.custom(isValidMobile, isValidMobileMsg),
    message: z.string().min(1, 'Please enter a message'),
    interset_in: z.string().min(1, 'Please select  interested in '),
  });

  type ContactValues = {
    email: string;
    password: string;
    full_name: string;
    message: string;
    phone: string;
    interset_in: string;
  };

  const handleSubmit = async (values: ContactValues) => {
    try {
      setLoading(true);

      await contactUS({ ...values });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Contact request sent successfully!',
      });
      onOpenModal();
    } finally {
      setLoading(false);
    }
  };
  const handleClosing = () => {
    navigate('/');
    onCloseModal();
  };
  return (
    <>
      <ContentLayout title={i18next.t('Contact')}>
        <Header type={HeaderType.LANDING} />

        <section className="get-intouch container">
          <div className="touch">
            <h3 className="semibold">Get In Touch</h3>
            <h2 className="us semibold">Touch With Us</h2>
          </div>
          <div className="row get">
            <div className="col-md-4 col-12 box">
              <div className="contact-col">
                <h2>01.</h2>
                <h5 className="semibold">{i18next.t('Phone')}</h5>
                <p>7681020400</p>
              </div>
            </div>
            <div className="col-md-4 col-12 box">
              <div className="contact-col">
                <h2>02.</h2>
                <h5 className="semibold">{i18next.t('Email')}</h5>
                <p>user@gmail.com</p>
              </div>
            </div>
            <div className="col-md-4 col-12 box boxn">
              <div className="contact-col">
                <h2>03.</h2>
                <h5 className="semibold">Social Media</h5>
                <p>
                  <i className="fa-brands fa-facebook"></i>
                  <i className="fa-brands fa-instagram"></i>
                  <i className="fa-brands fa-twitter"></i>
                  <i className="fa-brands fa-youtube"></i>
                </p>
              </div>
            </div>
          </div>
        </section>
        <section className="contact-form-rw bg-light-pink">
          <div className="container">
            <div className="row contact-form">
              <div className="col-md-6 col-12 left">
                <h2 className="contact-us f-40 semibold">
                  {i18next.t('Contact')}
                  <span className="us"> US!</span>
                </h2>
                <div className="form-boxes">
                  <Form<ContactValues, typeof schema> onSubmit={handleSubmit} schema={schema}>
                    {({ register, formState }) => (
                      <>
                        <div className="row">
                          <div className="col-md-6 col-12 no-space">
                            <InputField
                              label="Full Name"
                              error={formState.errors['full_name']}
                              registration={register('full_name')}
                            />
                          </div>
                          <div className="col-md-6 col-12 no-space">
                            <InputField
                              label={i18next.t('Email')}
                              error={formState.errors['email']}
                              registration={register('email')}
                            />
                          </div>

                          <div className="col-md-6 col-12 no-space">
                            <InputPhone
                              floating
                              error={formState.errors['phone']}
                              registration={register('phone')}
                            />
                          </div>
                          <div className="col-md-6 col-12 no-space">
                            <SelectField
                              label="What are you Interested in ."
                              error={formState.errors['interset_in']}
                              registration={register('interset_in')}
                              // placeholder="What are you Interested in ."
                              options={Object.entries(ConstactIntrestedin).map(([key, value]) => ({
                                label: value,
                                value: key,
                              }))}
                            />
                          </div>
                          <div className="col-12 no-space">
                            <TextAreaField
                              rows={4}
                              error={formState.errors['message']}
                              registration={register('message')}
                              label={i18next.t('Message')}
                            />
                          </div>
                        </div>

                        <Button isLoading={loading} type="submit">
                          Submit
                        </Button>
                        <div>
                          <Modal open={open} onClose={onCloseModal} center>
                            <section className="model-datas">
                              <h3>Thankyou for submitting Your Query</h3>
                              <p>
                                Lereom is simply a dummy text whixh is used for generating random
                                text for you website to make it more attaractive
                              </p>
                            </section>
                            <p className="btn-lines">
                              <Button onClick={handleClosing}>OKAY</Button>
                            </p>
                          </Modal>
                        </div>
                      </>
                    )}
                  </Form>
                </div>
              </div>
              <div className="col-md-6 col-12 right">
                <img src={house} alt="house" />
              </div>
            </div>
          </div>
        </section>

        <section className="container">
          <div className="row latest">
            <div className="col-12 col-md-12 col-lg-4">
              <h3>{i18next.t('Latest')}</h3>
              <h2> {i18next.t('Projects')}</h2>
              <p>
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed gravida eleifend
                placerat. Vivamus mollis tellus eget nulla placerat, ac bibendum turpis feugiat.
              </p>
              <p>
                <button onClick={() => navigate('/')}>See All</button>
              </p>
            </div>
            <div className="col-4 col-md-4"></div>
            <div className="col-4 col-md-4"></div>
          </div>
        </section>

        <br />
        <Footer />
      </ContentLayout>
    </>
  );
};
