import { ContentLayout } from '@/components/Layout';
import { useAuth } from '@/lib/auth';
import { ROLES } from '@/lib/authorization';
import i18next from 'i18next';

export const Dashboard = () => {
  const { user } = useAuth();
  return (
    <ContentLayout title={i18next.t('Dashboard')}>
      <h1 className="text-xl mt-2">
        {i18next.t('Welcome')} <b>{`${user?.first_name}`}</b>
      </h1>
      <h4 className="my-3">
        Your role is : <b>{user?.role}</b>
      </h4>
      <p className="font-medium">In this application you can:</p>
      {user?.role === ROLES.CUSTOMER && (
        <ul className="my-4 list-inside list-disc">
          <li>Create comments in discussions</li>
          <li>Delete own comments</li>
        </ul>
      )}
      {user?.role === ROLES.ADMIN && (
        <ul className="my-4 list-inside list-disc">
          <li>Create discussions</li>
          <li>Edit discussions</li>
          <li>Delete discussions</li>
          <li>Comment on discussions</li>
          <li>Delete all comments</li>
        </ul>
      )}
    </ContentLayout>
  );
};
