import Footer from '@/components/Layout/Footer/Footer';
import { ForSaleBread } from '@/components/Layout/ForSaleBread';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import { useEffect, useState } from 'react';
import './ForSale.css';

import BusinessSale from '@/features/user/components/BusinessSale';

import { ContentLayout } from '@/components/Layout';
import { useLandingListing } from '@/api/bussinessForSale/bussinessForSale';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import girlPic from '@/assets/girlPic.png';
import ServiceItemList from '@/features/misc/routes/Landing/ServiceItemList';
import i18next from 'i18next';

export const ForSale = () => {
  const [loading] = useState(false);

  const [object, setObject] = useState(null);
  const [saveSearch, setSaveSearch] = useState(false);
  const [heartClicked, setHeartClicked] = useState<boolean>();

  const {
    data: listing,
    isLoading,
    refetch,
    isFetching,
    isRefetching,
  } = useLandingListing({
    page: '1',
    min_price: '',
    max_price: '',
    location: '',
    type: '',
    amenities: '',
    filter_data: saveSearch,
    bedroom_min: '',
    bedroom_max: '',
    subscription_tyre: object?.subscriptionSort ? object?.subscriptionSort : '',
    sort_price: object?.priceSort,
  });

  const [clear, setClear] = useState(false);
  const [sendObj, setSendObj] = useState({});
  const obj = {
    priceSort: object?.priceSort,
    subscriptionSort: object?.subscriptionSort,
    timeSort: object?.timeSort,
  };
  const objNew = {
    priceSort: '',
    subscriptionSort: '',
    timeSort: '',
  };
  useEffect(() => {
    refetch();
    setHeartClicked(false);
    setSaveSearch(false);
    setSendObj(obj);
  }, [heartClicked, refetch, saveSearch]);

  useEffect(() => {
    setSaveSearch(false);
    setClear(false);
    refetch();
    setSendObj(objNew);
  }, [clear]);

  window.localStorage.setItem('filter_data', 'no');
  window.localStorage.setItem('company_type', 'Large');

  return (
    <>
      <BackdropLoader open={loading} />
      <ContentLayout title="For Sale">
        <div>
          <Header type={HeaderType.LANDING} />
          <ForSaleBread
            head={i18next.t('Invest in Companies Seeking Capital')}
            button={i18next.t('My Company seeks capital')}
            buttons={i18next.t('I want to sell my company')}
            photo={girlPic}
            linkAddress="/user/company-money"
            propertyType="2"
          />
          <ServiceItemList
            setObject={setObject}
            setSaveSearch={setSaveSearch}
            setClear={setClear}
            newObj={sendObj}
            linkAddress={'/Bussiness_for_sale?page=Bussiness_for_sale'}
          />
          <div className="saleContent container mb-5">
            {listing?.length == 0 ? (
              <h4 className="makeCenter m-4">No listing available !</h4>
            ) : (
              <div className="row">
                {isLoading || isFetching || isRefetching ? (
                  <MyListingLoader />
                ) : (
                  <>
                    {listing?.map((item, index) => (
                      <BusinessSale
                        headData={false}
                        editIcon={false}
                        deleteIcon={false}
                        key={index}
                        item={item}
                        setHeartClicked={setHeartClicked}
                        heartFavIcon={false}
                        heartIcon={false}
                        setDeleteClicked={undefined}
                      />
                    ))}
                  </>
                )}
              </div>
            )}
          </div>
          <Footer />
        </div>
      </ContentLayout>
    </>
  );
};
