import React from 'react';
import { useLandingListing } from '@/api/bussinessForSale/bussinessForSale';
import BusinessSale from '@/features/user/components/BusinessSale';
import i18next from 'i18next';

export const SmallCompany = () => {
  const { data: listing } = useLandingListing({ page: '1' });
  return (
    <>
      <p>
        <div className="apiContent row">
          <div className="col-6 col-md-6 left">Small Companies</div>
          <div className="col-6 col-md-6 right">
            <button>
              <i className="fa-solid fa-arrow-up-a-z"></i> {i18next.t('Filter')}
            </button>
          </div>
        </div>
        <div className="row">
          {listing?.map((item, index) => (
            <BusinessSale
              headData={false}
              editIcon={false}
              deleteIcon={false}
              key={index}
              item={item}
            />
          ))}
        </div>
      </p>
    </>
  );
};
