import Footer from '@/components/Layout/Footer/Footer';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import { useEffect, useState } from 'react';
import './HousingDetail.css';
import { useNavigate, useParams } from 'react-router-dom';
import { ContentLayout } from '@/components/Layout';
import logo from '@/assets/logofooter.png';
import { Button } from '@/components/Elements/Button';

import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import ToggleSwitch from '@/components/Elements/ToggleSwitch/ToggleSwitch';
import { Inquiry } from './Outlets/Inquiry';
import { useHousingIdDetails } from '@/api/housing/housingGetId';
import plus from '@/assets/plus.png';

import FileViewer from '@/components/Viewer/FileViewer';
import intro3 from '@/assets/intro3.png';
import clsx from 'clsx';
import propertyType from '@/constants/propertyType';
import { Image } from '@/components/Elements';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const HousingDetail = () => {
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { data } = useHousingIdDetails({ id: id ?? '2' });
  const [phone, setPhone] = useState<boolean>(false);
  const business = data?.data;
  const [open, setOpen] = useState(false);
  const [Photo, setPhoto] = useState<any>();
  const [Photo2, setPhoto2] = useState<any>();

  const [pics, setPics] = useState<any>();

  useEffect(() => {
    try {
      const picsArray = eval(business?.image_data);

      if (picsArray && picsArray.length > 0) {
        setPics(picsArray);
        setPhoto(picsArray[0]?.image);
        if (picsArray.length > 1) {
          setPhoto2(picsArray[1]?.image);
        }
      }
    } catch (error) {
      console.error('Error evaluating image_data:', error);
    }
  }, [business?.image_data]);

  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  const navigate = useNavigate();

  return (
    <ContentLayout title="Sale Detail">
      <div>
        <Header type={HeaderType.LANDING} />
        <button onClick={() => navigate(-1)}>
          <i className="fa-regular fa-circle-left go-back-button"></i>
        </button>

        <div className="container SaleContent">
          <div className="row">
            <div className="col-12 col-md-6 col-lg-5">
              <p className="line1">
                {business?.first_name ?? ''} {business?.last_name ?? ''}
              </p>
              <p className="line2">
                <i className="fa-solid fa-map-location-dot"></i> {business?.address ?? ''} ,{' '}
                {business?.country}
              </p>

              <p className="line4">{business?.email ?? ''}</p>
              <div className="line5">
                <div className="sl1 row">
                  <p className="left col-6 col-md-6">
                    {i18next.t('Max Monthly price')} ({localSymbol}):
                  </p>
                  <p className="right col-6 col-md-6">
                    {localSymbol}{' '}
                    {business?.max_month_price ? business?.max_month_price * localCurrency : ''}
                  </p>
                </div>
                <div className="sl1 row">
                  <p className="left col-6 col-md-6">{i18next.t('Number Of Resident')}</p>
                  <p className="right col-6 col-md-6">{business?.no_of_resident ?? ''}</p>
                </div>
                <div className="sl1 row">
                  <p className="left col-6 col-md-6">{i18next.t('House type')}</p>
                  <p className="right col-6 col-md-6">{propertyType[business?.property_type]}</p>
                  <p></p>
                </div>
                <div className="sl1 row">
                  <p className="left col-6 col-md-6">{i18next.t('Wanted From')}</p>
                  <p className="right col-6 col-md-6">{business?.wanted_from ?? ''}</p>
                </div>
                <div className="sl1 row">
                  <p className="left col-6 col-md-6">{i18next.t('Pet')}</p>
                  <p className="right col-6 col-md-6">{business?.pet ?? ''}</p>
                </div>
                <div className="sl1 row">
                  <p className="left col-6 col-md-6">{i18next.t('Furnishing')}</p>
                  <p className="right col-6 col-md-6">{business?.furnishings ?? ''}</p>
                </div>
              </div>
              <p>{business?.ad_header}</p>
            </div>
            <div className="col-12 col-md-6 col-lg-7 dp-prf-mob no-space">
              <div className="row">
                <div className="col-12 col-md-7">
                  <div className="flex items-center justify-center dpImage">
                    <span className="gender">{business?.gender}</span>
                    <img src={business?.image ?? intro3} alt="" />
                    {/* <FileViewer file={business?.image ?? intro3}></FileViewer> */}
                  </div>
                </div>
                <div className="col-12 col-md-5">
                  <div className="flex items-center justify-center ">
                    {business?.image_data.length == 0 ? (
                      <FileViewer file={plus ?? ''}></FileViewer>
                    ) : (
                      <Image
                        // imagefallback={eval(item?.image_data)[0]?.image}
                        className="itemImage"
                        alt="banner"
                        src={Photo ?? ''}
                      />
                    )}
                  </div>
                  <div className="flex items-center justify-center mt-2 ">
                    {business?.image_data.length == 0 ? (
                      <FileViewer file={plus ?? ''}></FileViewer>
                    ) : (
                      <Image
                        // imagefallback={eval(item?.image_data)[0]?.image}
                        className="itemImage"
                        alt="banner"
                        src={Photo2 ?? ''}
                      />
                    )}
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <section className="bg-light-pink">
          <div className="container outlets buisness-out">
            <div className="row">
              <div className="col-12 col-md-4 col-lg-3">
                <div className="card">
                  <p className="card-p1">
                    <img src={business?.image ?? intro3} alt="Profile Pic" />
                    {/* <FileViewer
                      file={business?.image ?? intro3}
                      style={{ width: '60%', maxHeight: 'none' }}
                    ></FileViewer> */}
                  </p>
                  <p className="card-p2 f-20 mb-1">
                    {business?.first_name} {business?.last_name}
                  </p>
                  <p className="card-p3 f-15">{i18next.t('Reeipo Real Estate Agent')}</p>
                  <p className="card-p4 w-90 mb-0">
                    <Button
                      onClick={() => setPhone(true)}
                      className={clsx(phone == true ? 'clearBack' : 'pinkBack')}
                    >
                      {phone ? (
                        <>
                          <span className="hhh">
                            <i className="fa-solid fa-phone-volume"></i> {business?.phone_number}
                          </span>
                        </>
                      ) : (
                        <>
                          <i className="fa-solid fa-phone-volume"></i>{' '}
                          {i18next.t('Show Phone Number')}
                        </>
                      )}
                    </Button>

                    {/* <Button onClick={onOpenModal}>Book a meeting</Button> */}
                    <Modal open={open} onClose={onCloseModal} center>
                      <div className="modal-contents row">
                        <div className="col-4 col-md-4 left">
                          <div>
                            <img src={logo} alt="pic" />
                          </div>
                          <div className="div-two">
                            <h4>{i18next.t('Book Call Appointment')}</h4>
                            <p>{i18next.t('with our Agent')}</p>
                          </div>
                          <div className="div-three">
                            <span>Carol Manyos</span>
                          </div>
                        </div>
                        <div className="col-8 col-md-8 right">
                          <h5>{i18next.t('Select Date And Time')}</h5>
                          <hr />
                          <div className="modal-btm row">
                            <div className="col-6 col-md-6 lefts">
                              <h6>{i18next.t('Select a time')}</h6>
                            </div>
                            <div className="col-6 col-md-6 rights">
                              <p>am/pm 24hrs</p>
                              <ToggleSwitch />
                            </div>
                            <div>
                              <span className="round-time">09:30 am</span>
                            </div>
                            <div className="modal-btns">
                              <Button>{i18next.t('Continue')}</Button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </Modal>
                  </p>
                  <p className="card-p5 w-90">
                    <Button>{i18next.t('Inquire Now')}</Button>
                  </p>
                </div>
              </div>
              <div className="col-12 col-md-8  col-lg-9 dp-prf-mob">
                <div className="intro">
                  <h4 className="bold f-32 ls-1 mb-1">{i18next.t('About Tenant')}</h4>
                  <div className="bg-white about-tenant">
                    <div className="row">
                      <div className="col-12 col-md-6">
                        <div className="study-status">
                          <span>{i18next.t('Study Status')}</span>
                          <span> {i18next.t('Full-time Student')} </span>
                        </div>
                        <div className="study-status">
                          <span>{i18next.t('Job Status')}</span>
                          <span>{i18next.t('Etterstod')}</span>
                        </div>
                        <div className="study-status">
                          <span>{i18next.t('Education')}</span>
                          <span>{i18next.t('Etterstod')}</span>
                        </div>
                        <div className="study-status">
                          <span>{i18next.t('Work')}</span>
                          <span>
                            {i18next.t('Scales')}, {i18next.t('BPA')}
                          </span>
                        </div>
                        <div className="study-status">
                          <span>{i18next.t('LinkedIn')}</span>
                        </div>
                      </div>
                      <div className="col-12 col-md-6">
                        <div className="study-status">
                          <span>{i18next.t('Marital Status')}</span>
                          <span>{i18next.t('Single')}</span>
                        </div>
                        <div className="study-status">
                          <span>{i18next.t('Cleanliness')}</span>
                          <span>{i18next.t('Tidy')}</span>
                        </div>
                        <div className="study-status">
                          <span>{i18next.t('Party Habits')}</span>
                          <span>{i18next.t('Does not Attach')}</span>
                        </div>
                        <div className="study-status">
                          <span>{i18next.t('Interests')}</span>
                          <span>
                            {i18next.t('Cooking')}, {i18next.t('Trips')}
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                  <h4 className="bold f-32 ls-1 mt-4 mb-1">
                    {i18next.t('French Bakery with four Outlets')}
                  </h4>
                  <p className="tenantIntro">{business?.about}</p>
                </div>
                {business?.customer_id && (
                  <>
                    <Inquiry customerIdentity={business?.customer_id} />
                  </>
                )}
              </div>
            </div>
          </div>
        </section>
        <Footer />
      </div>
    </ContentLayout>
  );
};
