import { useState } from 'react';
import { useHousingIdDetails } from '@/api/housing/housingGetId';

import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import intro3 from '@/assets/intro3.png';
import { Button } from '@/components/Elements';
import clsx from 'clsx';
import i18next from 'i18next';

function HousingDetailContent() {
  const { id } = useParams();
  const { data } = useHousingIdDetails({ id: id ?? '2' });
  const [phone, setPhone] = useState<boolean>(false);
  const business = data?.data;

  return (
    <>
      <div className="container SaleContent">
        <div className="row">
          <div className="col-12 col-md-6 col-lg-5">
            <p className="line1">
              {business?.first_name ?? ''} {business?.last_name ?? ''}
            </p>
            <p className="line2">
              <i className="fa-solid fa-map-location-dot"></i> {business?.nationality ?? ''}
            </p>

            <p className="line4">{business?.email ?? ''}</p>
            <div className="line5">
              <div className="sl1 row">
                <p className="left col-6 col-md-6">Max Month price:</p>
                <p className="right col-6 col-md-6">{business?.max_month_price ?? ''}</p>
              </div>
              <div className="sl1 row">
                <p className="left col-6 col-md-6">Number Of Resident</p>
                <p className="right col-6 col-md-6">{business?.no_of_resident ?? ''}</p>
              </div>
              <div className="sl1 row">
                <p className="left col-6 col-md-6">{i18next.t('House type')}</p>
                <p className="right col-6 col-md-6">{business?.property_type ?? ''}</p>
              </div>
              <div className="sl1 row">
                <p className="left col-6 col-md-6">{i18next.t('Wanted From')}</p>
                <p className="right col-6 col-md-6">{business?.wanted_from ?? ''}</p>
              </div>
            </div>
            <div className="row">
              <div className="col-md-7 phn">
                <Button
                  onClick={() => setPhone(true)}
                  className={clsx(phone == true ? 'clearBack' : 'pinkBack')}
                >
                  {phone ? (
                    <>
                      <span className="hhh">
                        <i className="fa-solid fa-phone-volume"></i> {business?.phone_number}
                      </span>
                    </>
                  ) : (
                    <>
                      <i className="fa-solid fa-phone-volume"></i> {i18next.t('Show Phone Number')}
                    </>
                  )}
                </Button>
              </div>
            </div>
          </div>
          <div className="col-12 col-md-6 col-lg-7">
            <div className="flex items-end justify-end">
              <FileViewer
                file={business?.image ?? intro3}
                style={{ width: '60%', maxHeight: 'none' }}
              ></FileViewer>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}

export default HousingDetailContent;
