import { useState } from 'react';
import intro1 from '@/assets/intro1.jpg';
import logo from '@/assets/logofooter.png';
import { Button } from '@/components/Elements/Button';
import { Bakery } from './Outlets/Bakery';
import { Accords } from './Outlets/Accords';
import { Inquiry } from './Outlets/Inquiry';
import { Intro } from './Outlets/Intro';

import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import ToggleSwitch from '@/components/Elements/ToggleSwitch/ToggleSwitch';
import { translateAmenties } from '@/translations/translateFunction';
import i18next from 'i18next';

function Outlets() {
  const [open, setOpen] = useState(false);

  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  return (
    <>
      <div className="container outlets">
        <div className="row">
          <div className="col-12 col-md-3">
            <div className="card">
              <p className="card-p1">
                <img src={intro1} alt="Profile Pic" />
              </p>
              <p className="card-p2">John Smith Reachel</p>
              <p className="card-p3">{i18next.t('Reeipo Real Estate Agent')}</p>
              <p className="card-p4">
                <Button onClick={onOpenModal}>Book a meeting</Button>
                <Modal open={open} onClose={onCloseModal} center>
                  <div className="modal-contents row">
                    <div className="col-4 col-md-4 left">
                      <div>
                        <img src={logo} alt="pic" />
                      </div>
                      <div className="div-two">
                        <h4>{i18next.t('Book Call Appointment')}</h4>
                        <p>{i18next.t('with our Agent')}</p>
                      </div>
                      <div className="div-three">
                        <span>Carol Manyos</span>
                      </div>
                    </div>
                    <div className="col-8 col-md-8 right">
                      <h5>{i18next.t('Select Date And Time')}</h5>
                      <hr />
                      <div className="modal-btm row">
                        <div className="col-6 col-md-6 lefts">
                          <h6>{i18next.t('Select a time')}</h6>
                        </div>
                        <div className="col-6 col-md-6 rights">
                          <p>am/pm 24hrs</p>
                          <ToggleSwitch />
                        </div>
                        <div>
                          <span className="round-time">09:30 am</span>
                        </div>
                        <div className="modal-btns">
                          <Button>{i18next.t('Continue')}</Button>
                        </div>
                      </div>
                    </div>
                  </div>
                </Modal>
              </p>
              <p className="card-p5">
                <Button>{translateAmenties('Inquire Now')}</Button>
              </p>
            </div>
            <Accords />
          </div>
          <div className="col-12 col-md-9">
            <Bakery />
            <Intro />
            <Inquiry />
          </div>
        </div>
      </div>
    </>
  );
}

export default Outlets;
