import React, { useEffect, useState } from 'react';
import * as z from 'zod';
import { useNavigate, useParams } from 'react-router-dom';
import { Form, InputField, TextAreaField } from '@/components/Form';
import { Button, Image } from '@/components/Elements';
import { inquiryPropertyForSale } from '@/api/propertyForSale/inquiryPropertyForSale';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useNotificationStore } from '@/stores/notifications';
import { useAuth } from '@/lib/auth';
import intro2 from '@/assets/intro2.png';
import './Outlet.css';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';

import { useHousingIdDetails } from '@/api/housing/housingGetId';
import FileViewer from '@/components/Viewer/FileViewer';
import { translateAmenties } from '@/translations/translateFunction';
import i18next from 'i18next';
export const Inquiry = (customerIdentity: any) => {
  const { id } = useParams();
  const { data } = useHousingIdDetails({ id: id ?? '2' });
  const business = data?.data;
  const [pics, setPics] = useState<any>();

  const [Photo3, setPhoto3] = useState<any>();
  useEffect(() => {
    try {
      const evaluatedData = eval(business?.image_data);
      setPics(evaluatedData);

      if (business?.image_data.length > 0 && pics) {
        setPhoto3(pics[2]?.image);
      }
    } catch (error) {
      console.error('An error occurred:', error);
    }
  }, [business?.image_data, pics]);

  const customerId = customerIdentity;
  const searchParams = new URLSearchParams(document.location.search);
  const typeVal = searchParams.get('type');

  const schema = z.object({
    telephone: z.custom(isValidMobile, isValidMobileMsg),

    message: z.string().min(1, 'Please enter a message'),
    email: z
      .string()
      .min(1, 'Please enter email address')
      .email('Please enter valid email address!'),
  });

  type inquiryAd = {
    telephone: string;
    message: string;
    email: string;
  };

  const auth = useAuth();

  const loggedinId = auth.user?.customer_id;
  const navigate = useNavigate();

  const [loading, setLoading] = useState(false);
  const handleSubmit = async (values: inquiryAd) => {
    try {
      setLoading(true);

      await inquiryPropertyForSale({
        ...values,
        project_id: `${id}`,
        id: `${id}`,
        type: `HouseRent`,
      });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'info',
        message: 'Inquiry Sent successfully!',
      });
    } finally {
      setLoading(false);
      localStorage.removeItem('values');
    }
  };

  return (
    <>
      <BackdropLoader open={loading} />
      <div className="inquiry">
        <h5>{i18next.t('Inquire About the Ads')}</h5>

        <div className=" row about-inq">
          <div className="col-md-7 left  propert-details no-space">
            <span className="titleHeader2"> {i18next.t('Inquiry about the ad')}</span>
            <div className="cardss iqforms">
              <fieldset disabled={loggedinId === customerId?.customerIdentity}>
                <Form<inquiryAd> onSubmit={handleSubmit} schema={schema} className="formMsg">
                  {({ register, formState }) => (
                    <>
                      <InputPhone
                        floating
                        error={formState.errors['telephone']}
                        registration={register('telephone')}
                      />

                      <InputField
                        label={translateAmenties('Email')}
                        error={formState.errors['email']}
                        registration={register('email')}
                      />
                      <TextAreaField
                        label={translateAmenties('Message')}
                        error={formState.errors['message']}
                        registration={register('message')}
                      />
                      {loggedinId === customerId && (
                        <p className="messages">You are owner of this Property</p>
                      )}
                      <div className="iq-div">
                        <Button type="submit" className="iq-btn">
                          {translateAmenties('Inquire Now')}
                        </Button>
                      </div>
                    </>
                  )}
                </Form>
              </fieldset>
            </div>
          </div>
          <div className="col-md-5 no-space right">
            <div className="topss">
              {business?.image_data.length == 0 ? (
                <FileViewer file={intro2 ?? ''}></FileViewer>
              ) : (
                <Image
                  // imagefallback={eval(item?.image_data)[0]?.image}
                  className="itemImage"
                  alt="banner"
                  src={Photo3 ?? ''}
                />
              )}
            </div>
            {/* <div className="bottms"> */}
            <div>
              <div>
                <h5>{business?.customer_name}</h5>
                <p className="nam">Bio here</p>
              </div>
            </div>
            <Button
              className="mt-2"
              onClick={() => navigate(`/profile-details?id=${customerId?.customerIdentity}`)}
            >
              {i18next.t(' View Profile')}
            </Button>
          </div>
        </div>
      </div>
    </>
  );
};
//c
