/* eslint-disable react/jsx-key */
import React, { useEffect, useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import './landing.css';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import BreadCrumb from '@/components/Layout/BreadCrumb';
import ServiceItemList from '../Landing/ServiceItemList';
import HousingRent from '@/features/user/components/HousingRent';
import { useHousingListing } from '@/api/housing/getHousingList';
import { ContentLayout } from '@/components/Layout';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import i18next from 'i18next';

export const HousingForRent = () => {
  const [loading] = useState(false);

  const [heartClicked, setHeartClicked] = useState<boolean>();
  const [object, setObject] = useState(null);
  const [saveSearch, setSaveSearch] = useState(false);

  const {
    data: listing,
    isLoading,
    refetch,
  } = useHousingListing({
    page: '1',
    min_price: '',
    max_price: '',
    location: '',
    type: '',
    amenities: '',
    filter_data: saveSearch,
    bedroom_min: '',
    bedroom_max: '',
    subscription_tyre: object?.subscriptionSort ? object?.subscriptionSort : '',
    sort_price: object?.priceSort,
  });
  const [clear, setClear] = useState(false);
  const [sendObj, setSendObj] = useState({});
  const obj = {
    priceSort: object?.priceSort,
    subscriptionSort: object?.subscriptionSort,
    timeSort: object?.timeSort,
  };
  const objNew = {
    priceSort: '',
    subscriptionSort: '',
    timeSort: '',
  };
  useEffect(() => {
    refetch();
    setHeartClicked(false);
    setSaveSearch(false);
    setSendObj(obj);
  }, [heartClicked, refetch, saveSearch]);

  useEffect(() => {
    setSaveSearch(false);
    setClear(false);
    refetch();
    setSendObj(objNew);
  }, [clear]);

  return (
    <>
      <ContentLayout title="House For Rent">
        <BackdropLoader open={loading} />
        <Header type={HeaderType.LANDING} />
        <BreadCrumb
          line2={i18next.t('Explore Qualified Renters')}
          paragraph="Our free listings focus on renters who know what they want and are ready to move into a new place quickly."
        />
        <br />

        <div className="container">
          <ServiceItemList
            setObject={setObject}
            setSaveSearch={setSaveSearch}
            setClear={setClear}
            newObj={sendObj}
            linkAddress={'/Propert_sale_rent?page=Propert_sale_rent'}
          />
          <div className="row">
            {listing?.length == 0 ? (
              <h4 className="makeCenter">No listing found !</h4>
            ) : (
              <>
                {isLoading ? (
                  <MyListingLoader />
                ) : (
                  <>
                    {listing?.map((item, index) => (
                      <HousingRent
                        headData={false}
                        editIcon={false}
                        deleteIcon={false}
                        key={index}
                        item={item}
                        setHeartClicked={setHeartClicked}
                        setDeleteClicked={undefined}
                      />
                    ))}
                  </>
                )}
              </>
            )}
          </div>
          <div className="row"></div>
        </div>
        <br />
        <Footer />
      </ContentLayout>
    </>
  );
};
