import React, { useEffect, useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import { Col, Nav, NavItem, NavLink, Row, TabContent, TabPane } from 'reactstrap';
import { useParams, useNavigate } from 'react-router-dom';
import BreadCrumb from '@/components/Layout/BreadCrumb';
import Footer from '@/components/Layout/Footer/Footer';
import clsx from 'clsx';
import './HowItWorks.css';
import HowIW from './HowIW';
import { howItWorks } from '@/api/howItWorks/howItWorks';
import { InvestorContent } from '@/types/InvestorContent';
import FaqContents from './FaqContents';
import HowItWorkLoader from '@/components/Elements/Loader/HowItWorkLoader';
import i18next from 'i18next';
//c
export const HowItWorks = () => {
  const searchParams = new URLSearchParams(document.location.search);
  const pageName = searchParams.get('page');
  const [loading, setLoading] = useState(false);
  const navigate = useNavigate();

  const [data, setData] = useState<InvestorContent[]>([]);

  const getData = async () => {
    setLoading(true);
    const { data } = await howItWorks(pageName ?? '');
    setData(data);
    setLoading(false);
  };
  useEffect(() => {
    getData();
  }, [pageName]);

  const articleContent = data.page_content;

  const tabs = {
    investor: {
      title: 'Investor',
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/investor');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    Propert_sale_rent: {
      title: 'Propert Sale Rent',
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/property-for-sale');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    Bussiness_for_sale: {
      title: `${i18next.t('Business For Sale')}`,
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/business-for-sale');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    Bussiness_developer: {
      title: 'Bussiness Developer',
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/business-developer');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    property_developer: {
      title: `${i18next.t('Property Developer')}`,
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/project-developer');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    Property_project: {
      title: 'Property project',
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/property-project');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    project_type: {
      title: `${i18next.t('Project Type')}`,

      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/project-type');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    faq: {
      title: 'FAQ',
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2">
            {pageName === 'faq' ? <FaqContents /> : null}
          </Col>
        </Row>
      ),
    },
    sales_condition: {
      title: 'Sales Conditions',
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/sales-conitions');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
    how_It_work: {
      title: 'How It Work',
      content: (
        <Row className="p-2">
          <Col sm="12" className="p-2 howItTabs">
            {data?.page_title ? (
              <>
                <h4 className="title_hiw">
                  {data.page_title}{' '}
                  <i
                    className="fa fa-link ml-2"
                    style={{ color: 'black', cursor: 'pointer' }}
                    onClick={() => {
                      navigate('/how_It_work');
                    }}
                  ></i>
                </h4>
                <div dangerouslySetInnerHTML={{ __html: articleContent }} />
              </>
            ) : (
              <h4 className="makeCenter">No data found</h4>
            )}
          </Col>
        </Row>
      ),
    },
  };

  const { active_tab } = useParams();
  const history = useNavigate();

  useEffect(() => {
    if (!active_tab) {
      history(`/investor?page=investor`);
    }
  });

  const toggle = (tab: string | undefined) => {
    if (active_tab !== tab) {
      history(`/${tab}?page=${tab}`);
    }
  };

  return (
    <>
      {loading ? (
        <HowItWorkLoader />
      ) : (
        <>
          <Header type={HeaderType.LANDING} />
          <BreadCrumb
            line2="How It Works"
            // paragraph="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
            // incididunt ut labore et dolore magna aliqua"
          />
          <div className="container HIW">
            <div className="row pt-4">
              <div className="col-12 col-md-4 col-lg-3  sides_menu">
                <h4 className="main-head4">How it Works</h4>
                <Nav tabs>
                  {Object.entries(tabs).map((tab) => (
                    <NavItem key={tab[0]}>
                      <NavLink
                        className={clsx('NavLinker', active_tab === tab[0] ? 'active' : '')}
                        onClick={() => {
                          toggle(tab[0]);
                        }}
                        role="button"
                      >
                        {tab[1].title}
                      </NavLink>
                    </NavItem>
                  ))}
                </Nav>
              </div>
              <div className="col-12 col-md-8 col-lg-9  contents-menus">
                <TabContent activeTab={active_tab}>
                  {Object.entries(tabs).map((tab) => (
                    <TabPane key={tab[0]} tabId={tab[0]}>
                      {tab[1].content}
                    </TabPane>
                  ))}
                </TabContent>
              </div>
            </div>
          </div>
          <div className="container">
            <HowIW />
          </div>
          <br />
          <Footer />
        </>
      )}
    </>
  );
};
