/* eslint-disable react/jsx-key */
import React, { useEffect, useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import './landing.css';
import BreadCrumb from '@/components/Layout/BreadCrumb';
import SearchForm from '@/components/Elements/SearchForm/SearchForm';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useLandingListing } from '@/api/landing/landingListing';
import ServiceItemList from './ServiceItemList';
import ServiceItem from '@/features/user/components/ServiceItem';
import { ContentLayout } from '@/components/Layout';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { saveSearchApi } from '@/api/Search/saveSearchApi';
import { useNotificationStore } from '@/stores/notifications';
import { Filter } from './filterType';
import { useLocation } from 'react-router-dom';
import i18next from 'i18next';

export const Landing = () => {
  const [loading] = useState(false);

  useEffect(() => {
    const url = new URL(window.location.href);

    const paymentSuccess = url.searchParams.get('paymentpalsuccess');

    if (paymentSuccess === 'true') {
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Payment Completed successfully!',
      });
    }
  }, []);

  const [type, settype] = useState('');
  const [min_price, setmin_price] = useState('');
  const [max_price, setmax_price] = useState('');
  const [location, setlocation] = useState('');
  const [lat, setlat] = useState('');
  const [lng, setlng] = useState('');
  const [search, setSearch] = useState(false);
  const [save, setSave] = useState(false);
  const [heartClickedLanding, setHeartClickedLanding] = useState(false);
  const path = useLocation();
  // const [isLoading, setisLoading] = useState(false);

  // ------------------ Save search ----------------
  const [loadingSave, setLoadingSave] = useState(false);
  const [object, setObject] = useState<Filter | null>(null);
  const [saveSearch, setSaveSearch] = useState(true);
  const [clearSearchVal, setClearSearchVal] = useState(false);

  const min_beds = '';
  const max_beds = '';
  const amenities = '';

  useEffect(() => {
    if (min_price == undefined) {
      setmin_price('');
    }
    if (max_price == undefined) {
      setmax_price('');
    }
  }, [min_price, max_price]);
  // ------------------ Save search ----------------

  // Create a URLSearchParams object with the query string
  const searchParams = new URLSearchParams(document.location.search);

  // Extract the values
  const typeValue = searchParams.get('type');
  const locationValue = searchParams.get('location');
  const minPriceValue = searchParams.get('min_price');
  const maxPriceValue = searchParams.get('max_price');
  const latitudeValue = searchParams.get('latitude');
  const longitudeValue = searchParams.get('longitude');
  const isTrue = searchParams.get('isTrue');
  const urlVal = `/?isTrue=true?type=${type}&location=${location}&latitude=${lat}&longitude=${lng}&min_price=${min_price}&max_price=${max_price}`;

  useEffect(() => {
    setHeartClickedLanding(false);
  }, [heartClickedLanding]);

  useEffect(() => {
    if (clearSearchVal === true) {
      settype('');
      setmin_price('');
      setmax_price('');
      setlocation('');
      setlat('');
      setlng('');
      setSearch(false);
      setSave(false);
      setClearSearchVal(false);
    }
  }, [clearSearchVal]);

  const {
    data: listing,
    isLoading,
    refetch,
    isFetching,
  } = useLandingListing({
    page: '1',
    min_price: clearSearchVal ? '' : isTrue ? minPriceValue : min_price,
    max_price: clearSearchVal ? '' : isTrue ? maxPriceValue : max_price,
    location: clearSearchVal ? '' : isTrue ? locationValue : location,
    latitude: clearSearchVal ? '' : isTrue ? (latitudeValue ? latitudeValue : '') : lat ? lat : '',
    longitude: clearSearchVal
      ? ''
      : isTrue
        ? longitudeValue
          ? longitudeValue
          : ''
        : lng
          ? lng
          : '',
    type: clearSearchVal ? '' : isTrue ? typeValue : type ? type : '',
    amenities: amenities,
    filter_data: saveSearch,
    bedroom_min: min_beds,
    bedroom_max: max_beds,
    subscription_tyre: object?.subscriptionSort ? object?.subscriptionSort : '',
    sort_price: object?.priceSort ? object?.priceSort : '',
    sort_upload_date: object?.timeSort ? object?.timeSort : '',
  });

  const [clear, setClear] = useState(false);
  const [sendObj, setSendObj] = useState({});
  const obj = {
    priceSort: object?.priceSort,
    subscriptionSort: object?.subscriptionSort,
    timeSort: object?.timeSort,
  };
  const objNew = {
    priceSort: '',
    subscriptionSort: '',
    timeSort: '',
  };
  useEffect(() => {
    refetch();
    // setHeartClicked(false);
    setSaveSearch(false);
    setSendObj(obj);
    setClearSearchVal(false);
  }, [refetch, saveSearch, search, isTrue, heartClickedLanding]);

  useEffect(() => {
    if (clearSearchVal === true) {
      refetch();
      setClearSearchVal(false);
    }
  }, [clearSearchVal]);

  useEffect(() => {
    setSaveSearch(false);
    setClear(false);
    refetch();
    setSendObj(objNew);
    setClearSearchVal(false);
  }, [clear, clearSearchVal]);

  const handleSearchApi = async (objects: any) => {
    await setSaveSearch(true);

    try {
      setLoadingSave(true);
      await saveSearchApi(objects);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have saved this request successfully!',
      });
    } finally {
      setLoadingSave(false);
      setSave(false);
    }
  };

  const dataToSave = {
    type,
    min_price,
    max_price,
    location,
    lat,
    lng,
    min_beds,
    max_beds,
    amenities,
    type_url: urlVal,
  };

  useEffect(() => {
    if (save === true) {
      handleSearchApi(dataToSave);
    }
  }, [save]);

  // ------------------ Save search ----------------
  // favourite-list

  return (
    <>
      <ContentLayout title="Home">
        <BackdropLoader open={loading} />
        <Header type={HeaderType.LANDING} />
        <BreadCrumb
          head={i18next.t('Explore REEIPO')}
          line2={i18next.t('The Next Era in Real Estate')}
          paragraph={i18next.t(
            `A platform where properties, projects, and real estate opportunities intersect with connections determined to see them thrive in today's dynamic markets.`
          )}
        />
        <SearchForm
          settype={settype}
          setmin_price={setmin_price}
          setmax_price={setmax_price}
          setlocation={setlocation}
          setSearch={setSearch}
          setSave={setSave}
          setlat={setlat}
          setlng={setlng}
          setClearSearchVal={setClearSearchVal}
        />
        {/* <Carousel /> */}
        <ServiceItemList
          setObject={setObject}
          setSaveSearch={setSaveSearch}
          setClear={setClear}
          newObj={sendObj}
        />
        ;
        <div className="container">
          <div className="row">
            {listing?.length == 0 ? (
              <h4 className="makeCenter">{i18next.t('No listing found !')}</h4>
            ) : (
              <>
                {isLoading || isFetching ? (
                  <MyListingLoader />
                ) : (
                  <>
                    {listing?.map((item, index) => (
                      <ServiceItem
                        key={index}
                        item={item}
                        showEditIcon={false}
                        showDeleteIcon={false}
                        showHeartIcon={true}
                        setDeleteRefetch={undefined}
                        setHeartClickedLanding={setHeartClickedLanding}
                      />
                    ))}
                  </>
                )}
              </>
            )}
          </div>
        </div>
        <br />
        <Footer />
      </ContentLayout>
    </>
  );
};
