import React from 'react';
import './OurService.css';
import h1 from '@/assets/h1.png';
import h2 from '@/assets/h2.png';
import h3 from '@/assets/h3.png';
import h4 from '@/assets/h4.png';
import i18next from 'i18next';

function CoreService() {
  return (
    <div className=" container core-service">
      <p className="topP">{i18next.t('Our Services')}</p>
      <h4 className="topH">{i18next.t('Our Core Services')}</h4>
      <div className="boxFour row">
        <div className="boxOut col-12 col-md-6 col-lg-3">
          <div className="boxIn">
            <span>
              <img src={h4} alt="box" />
            </span>
            <h5>{i18next.t('Advertising')}</h5>
            <p>
              {i18next.t(
                'Use REEIPO to your advantage! We have an extensive network of contacts looking for all kinds of property opportunities.'
              )}
            </p>
          </div>
        </div>
        <div className="boxOut col-12 col-md-6 col-lg-3">
          <div className="boxIn">
            <span>
              <img src={h3} alt="box" />
            </span>
            <h5>{i18next.t('Property Assistance')}</h5>
            <p>
              {i18next.t(
                'Our expert team is ready to help you evaluate, list, learn, and more related to property. Connect with us today.'
              )}
            </p>
          </div>
        </div>
        <div className="boxOut col-12 col-md-6 col-lg-3">
          <div className="boxIn">
            <span>
              <img src={h2} alt="box" />
            </span>
            <h5>{i18next.t('Investments')}</h5>
            <p>
              {i18next.t(
                'Real estate is always attractive to investors, and we’re working to make all levels of investment safer for more diversified portfolios.'
              )}
            </p>
          </div>
        </div>
        <div className="boxOut col-12 col-md-6 col-lg-3">
          <div className="boxIn">
            <span>
              <img src={h1} alt="box" />
            </span>
            <h5>{i18next.t('Cooperation')}</h5>
            <p>
           {i18next.t('We help facilitate cooperation between those with capital and those with projects to move more projects forward.')}
            </p>
          </div>
        </div>
      </div>
    </div>
  );
}

export default CoreService;
