import React from 'react';
import serviceAbout from '@/assets/serviceAbout.png';
import { Button } from '@/components/Elements';
import './OurService.css';
import { useNavigate } from 'react-router-dom';
import i18next from 'i18next';

function ServiceAbout() {
  const navigate = useNavigate();
  return (
    <div className="container row serviceAbout">
      <div className="col-12 col-md-6 left">
        <span>
          <img src={serviceAbout} alt="asas" />
        </span>
      </div>
      <div className="col-12 col-md-6 right">
        <p className="sp1">{i18next.t('About Us')}</p>
        <p className="sp2">
          {i18next.t('REEIPO puts everything related to property at your fingertips')}
        </p>
        <p className="sp3">
          {i18next.t('REEIPO was born from our passion for property, and now we’re thrilled to share it with you. Check out all the features our experience with property in Norway and abroad brings to the website today, and enjoy finding projects again.')}


          <br /> REEIPO started because we wanted a different experience than what we found on
          property and real estate websites. So, we combined our expertise and focused on bringing
          our networks together to create a new way of looking at property.
        </p>
        <p className="sp4">
          <Button onClick={() => navigate('/about-us')}>{i18next.t('About Us')}</Button>
        </p>
      </div>
    </div>
  );
}

export default ServiceAbout;
