import React, { useEffect, useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import { ContentLayout } from '@/components/Layout';
import { usePrivacyPolicy } from '@/api/privacyPolicy';
import TermsLoader from '@/components/Elements/Loader/TermsLoader';
import i18next from 'i18next';

export const PrivacyPoilcy = () => {
  // const data = termsCondition();
  const { data, isLoading } = usePrivacyPolicy();
  const lang = localStorage.getItem('lang') || 'no';

  const [load, setLoad] = useState(false);
  const [articleContent, setarticleContent] = useState<any>(null);

  useEffect(() => {
    setLoad(true);
    if (lang === 'no') {
      setarticleContent(data?.data?.page_content_nw);
    } else {
      setarticleContent(data?.data?.page_content);
    }
    setLoad(false);
  }, [lang, data]);

  return (
    <ContentLayout title={i18next.t('Terms & Conditions')}>
      <div>
        <Header type={HeaderType.LANDING} />
        <section className="promo-about-pg py-4">
          <div className="container">
            <div className="about-content text-center">
              <h2 className="f-30 semibold">
                {lang === 'no' ? data?.data?.page_title_nw : data?.data?.page_title}
              </h2>
            </div>
          </div>
        </section>
        {isLoading || load ? (
          <TermsLoader />
        ) : (
          <section className="about-privacy about-content-first  pt-4 pb-5">
            <div className="container">
              <div className="about-us-box">
                {/* <h2 className="f-30 semibold mb-2">{data?.data?.page_title}</h2> */}
                <div className="bg-light-pink abt">
                  {articleContent && <div dangerouslySetInnerHTML={{ __html: articleContent }} />}
                </div>
              </div>
            </div>
          </section>
        )}
        <Footer />
      </div>
    </ContentLayout>
  );
};
