import React from 'react';
import { Button } from '@/components/Elements/Button';
import Sliders from '@/components/Elements/Slider/Sliders';
import PropertyStatus from './PropertyStatus';
import './SearchForm.css';
import FormInside from './FormInside';

const CommercialForm = () => {
  const [open, setOpen] = React.useState(false);
  const [open2, setOpen2] = React.useState(false);

  const handleOpen = () => {
    setOpen(!open);
  };

  const handleOpen2 = () => {
    setOpen2(!open2);
  };

  return (
    <div className="roundbox">
      <div className="outer row">
        <div className="left col-12 col-md-10">
          <div className="row">
            <div className="col-12 col-md-3 bloks ">
              <form>
                <input placeholder="Location" className="prices" type="text" name="name" />
              </form>
            </div>
            <div className="col-12 col-md-3 bloks ">
              <PropertyStatus />
            </div>
            <div className="col-12 col-md-3 bloks ">
              <button className="prices" onClick={handleOpen}>
                Price Range
              </button>
              {open ? (
                <div className="progress-div qleft ">
                  <div>
                    <p className="p2">
                      <Sliders />
                    </p>
                    <p className="p3 row">
                      <span className="col-6 col-md-6">0</span>
                      <span className="col-6 col-md-6 lt">£10,000</span>
                    </p>
                  </div>
                </div>
              ) : null}
            </div>

            <div className="col-12 col-md-3 bloks ">
              <button className="prices" onClick={handleOpen2}>
                More
              </button>
              {open2 ? (
                <div className="MoreDiv ">
                  <div className="col-md-12 col-12 lefti">
                    <FormInside />
                  </div>
                </div>
              ) : null}
            </div>
          </div>
        </div>
        <div className="right col-12 col-md-2 ">
          <Button className="btn-rounded bttn">Search</Button>
        </div>
      </div>
    </div>
  );
};

export default CommercialForm;
