import React from 'react';
import FormGroup from '@mui/material/FormGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import { Form, InputField } from '@/components/Form';
import Checkbox from '@mui/material/Checkbox';
import { Button } from '@/components/Elements';
import i18next from 'i18next';

function FormInside() {
  type FormValues = {
    bathroom: string;
    size: string;
  };
  return (
    <>
      <div className="mainz">
        <p>Listed By</p>
        <FormGroup>
          <div className="row">
            <div className="col-md-4 col-4">
              {' '}
              <FormControlLabel control={<Checkbox />} label="Stydu" />
            </div>
            <div className="col-md-4 col-4">
              {' '}
              <FormControlLabel control={<Checkbox />} label="Stydu" />
            </div>
            <div className="col-md-4 col-4">
              {' '}
              <FormControlLabel control={<Checkbox />} label="Stydu" />
            </div>
          </div>
        </FormGroup>
      </div>
      <hr />
      <div>
        <Form<FormValues>
          onSubmit={async (values) => {
            alert(JSON.stringify(values, null, 2));
          }}
          id="my-form"
        >
          {({ register, formState }) => (
            <>
              <InputField
                label={i18next.t('Bathroom')}
                error={formState.errors['bathroom']}
                registration={register('bathroom')}
              />
            </>
          )}
        </Form>
      </div>
      <hr />
      <div>
        <Form<FormValues>
          onSubmit={async (values) => {
            alert(JSON.stringify(values, null, 2));
          }}
          id="my-form"
        >
          {({ register, formState }) => (
            <>
              <InputField
                label={`Size (${i18next.t('Sq.Ft')})`}
                error={formState.errors['size']}
                registration={register('size')}
              />
            </>
          )}
        </Form>
      </div>
      <hr />
      <div>
        <p>Verified Ads Only</p>
        <FormGroup>
          <FormControlLabel control={<Checkbox />} label="Verified Ads   Only" />
        </FormGroup>
      </div>
      <hr />
      <div>
        <p>Ads with Video Only</p>
        <FormGroup>
          <FormControlLabel control={<Checkbox />} label="Ads with video Only" />
        </FormGroup>
      </div>
      <hr />
      <div>
        <p>Ads with 360 Tour Only</p>
        <FormGroup>
          <FormControlLabel control={<Checkbox />} label="Ads with 360 Tour Only" />
        </FormGroup>
        <Button type="submit" className="w-full">
          {i18next.t('Search')}
        </Button>
      </div>
    </>
  );
}

export default FormInside;
