import React from 'react';
import { Button } from '@/components/Elements/Button';
import Sliders from '@/components/Elements/Slider/Sliders';
import './SearchForm.css';
import FormInside from './FormInside';
import FormGroup from '@mui/material/FormGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import i18next from 'i18next';

const LandForm = () => {
  const [open, setOpen] = React.useState(false);
  const [open1, setOpen1] = React.useState(false);
  const [open2, setOpen2] = React.useState(false);

  const handleOpen = () => {
    setOpen(!open);
  };
  const handleOpen1 = () => {
    setOpen1(!open1);
  };

  const handleOpen2 = () => {
    setOpen2(!open2);
  };

  return (
    <div className="roundbox">
      <div className="outer row">
        <div className="left col-12 col-md-10">
          <div className="row">
            <div className="col-12 col-md-3 bloks ">
              <form>
                <input
                  placeholder={i18next.t('Location')}
                  className="prices"
                  type="text"
                  name="name"
                />
              </form>
            </div>

            <div className="col-12 col-md-3 bloks ">
              <button className="prices" onClick={handleOpen}>
                Price Range
              </button>
              {open ? (
                <div className="progress-div qleft ">
                  <div>
                    <p className="p2">
                      <Sliders />
                    </p>
                    <p className="p3 row">
                      <span className="col-6 col-md-6">0</span>
                      <span className="col-6 col-md-6 lt">£10,000</span>
                    </p>
                  </div>
                </div>
              ) : null}
            </div>

            <div className="col-12 col-md-3 bloks ">
              <button className="prices" onClick={handleOpen1}>
                Zoned For
              </button>
              {open1 ? (
                <div className="MoreDiv ">
                  <div className="col-md-12 col-12 lefti">
                    <FormGroup>
                      <FormControlLabel control={<Checkbox />} label="Residential" />
                      <FormControlLabel control={<Checkbox />} label="Commercial" />
                      <FormControlLabel control={<Checkbox />} label="Industrial" />
                      <FormControlLabel control={<Checkbox />} label="Retail" />
                      <FormControlLabel control={<Checkbox />} label="Mixed Use" />
                    </FormGroup>
                  </div>
                </div>
              ) : null}
            </div>

            <div className="col-12 col-md-3 bloks ">
              <button className="prices" onClick={handleOpen2}>
                More
              </button>
              {open2 ? (
                <div className="MoreDiv ">
                  <div className="col-md-12 col-12 lefti">
                    <FormInside />
                  </div>
                </div>
              ) : null}
            </div>
          </div>
        </div>
        <div className="right col-12 col-md-2 ">
          <Button className="btn-rounded bttn">{i18next.t('Search')}</Button>
        </div>
      </div>
    </div>
  );
};

export default LandForm;
