import React, { useState } from 'react';
import clsx from 'clsx';
import DropDown from '@/components/Elements/DropDown/DropDown';

const MinimumBed: React.FC = (): JSX.Element => {
  const [showDropDown, setShowDropDown] = useState<boolean>(false);
  const [selectCity, setSelectCity] = useState<string>('');
  const cities = () => {
    return ['1 Bedroom', '2 Bedroom', '3 Bedroom', '4 Bedroom', '5 Bedroom', '6 Bedroom'];
  };

  const toggleDropDown = () => {
    setShowDropDown(!showDropDown);
  };

  const dismissHandler = (event: React.FocusEvent<HTMLButtonElement>): void => {
    if (event.currentTarget === event.target) {
      setShowDropDown(false);
    }
  };

  const citySelection = (city: string): void => {
    setSelectCity(city);
  };

  return (
    <div className="dd">
      <button
        className={clsx('drops', showDropDown ? 'active' : undefined)}
        onClick={(): void => toggleDropDown()}
        onBlur={(e: React.FocusEvent<HTMLButtonElement>): void => dismissHandler(e)}
      >
        <div>{selectCity ? selectCity : 'Minimum >'} </div>
        {showDropDown && (
          <DropDown
            cities={cities()}
            showDropDown={false}
            toggleDropDown={(): void => toggleDropDown()}
            citySelection={citySelection}
          />
        )}
      </button>
    </div>
  );
};

export default MinimumBed;
