/* eslint-disable react/jsx-key */
import { useEffect, useState } from 'react';
import Footer from '@/components/Layout/Footer/Footer';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import './landing.css';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import BreadCrum from './BreadCrum';
import { ContentLayout } from '@/components/Layout';
import { usePropertyForRent } from '@/api/propertyForRent/propertyForRent';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import PropertyForRentItem from '@/features/user/components/PropertyForRentItem';
import PFSSearchForm from '../PropertyForSale/PFSSearchForm';
import { saveSearchApi } from '@/api/Search/saveSearchApi';
import { useNotificationStore } from '@/stores/notifications';
import ServiceItemList from '@/features/misc/routes/Landing/ServiceItemList';
import storage from '@/utils/storage';
import axios from 'axios';
import Checkbox from '@mui/material/Checkbox';
import FormControlLabel from '@mui/material/FormControlLabel';
import { Filter } from '../Landing/filterType';
import i18next from 'i18next';

export const PropertyForRent = () => {
  const [loading] = useState(false);
  const [heartClicked, setHeartClicked] = useState<boolean>();

  const [minPrice, setMinPrice] = useState('');
  const [maxPrice, setMaxPrice] = useState('');
  const [minBeds, setMinBeds] = useState('');
  const [maxBeds, setMaxBeds] = useState('');
  const [amenities, setAmenities] = useState('');
  const [location, setlocation] = useState('');
  const [search, setSearch] = useState(false);
  const [save, setSave] = useState(false);
  const [loadingSave, setLoadingSave] = useState(false);
  const [object, setObject] = useState<Filter | null>(null);
  const [saveSearch, setSaveSearch] = useState(false);
  const [lat, setlat] = useState('');
  const [lng, setlng] = useState('');
  const [clearSearchVal, setClearSearchVal] = useState(false);

  // Create a URLSearchParams object with the query string
  const searchParams = new URLSearchParams(document.location.search);

  // Extract the values
  const locationValue = searchParams.get('location');
  const minPriceValue = searchParams.get('min_price');
  const maxPriceValue = searchParams.get('max_price');
  const latitudeValue = searchParams.get('latitude');
  const longitudeValue = searchParams.get('longitude');
  const minBedValue = searchParams.get('bedroom_min');
  const maxBedValue = searchParams.get('bedroom_max');
  const amenitiesValues = searchParams.get('amenities');
  const isTrue = searchParams.get('isTrue');
  const category = searchParams.get('type');

  const [selectedCountry, setCountry] = useState('');
  const [selectedState, setState] = useState('');
  const [selectedCity, setCity] = useState('');

  const handleCountryCheckboxChange = (stateName) => {
    setCountry(stateName);
  };
  const handleStateCheckboxChange = (stateName) => {
    setState(stateName);
  };
  const handleCityCheckboxChange = (stateName) => {
    setCity(stateName);
  };
  const countryFilter = selectedCountry.toString();
  const stateFilter = selectedState.toString();
  const cityFilter = selectedCity.toString();

  const type_url = `/property-for-rent?isTrue=true?type=RentProperty&location=${location}&longitude=${lng}&latitude=${lat}&min_price=${minPrice}&max_price=${maxPrice}&bedroom_min=${minBeds}&bedroom_max=${maxBeds}&amenities=${amenities}`;
  const type = '';
  const dataToSave = {
    type,
    min_price: minPrice,
    max_price: maxPrice,
    location: location,
    min_beds: minBeds,
    max_beds: maxBeds,
    amenities: amenities,
    type_url,
  };

  useEffect(() => {
    if (clearSearchVal === true) {
      // settype('');
      setMinPrice('');
      setMinPrice('');
      setlocation('');
      setlat('');
      setlng('');
      setSearch(false);
      setSave(false);
      setClearSearchVal(false);
    }
  }, [clearSearchVal]);
  useEffect(() => {
    if (minPrice == undefined) {
      setMinPrice('');
    }
    if (maxPrice == undefined) {
      setMaxPrice('');
    }
  }, [minPrice, maxPrice]);

  const {
    data: listing,
    isLoading,
    isFetching,
    isRefetching,
    refetch,
  } = usePropertyForRent({
    page: '1',
    min_price: clearSearchVal ? '' : isTrue ? minPriceValue : minPrice,
    max_price: clearSearchVal ? '' : isTrue ? maxPriceValue : maxPrice,
    location: clearSearchVal ? '' : isTrue ? locationValue : location,
    latitude: clearSearchVal ? '' : isTrue ? (latitudeValue ? latitudeValue : '') : lat ? lat : '',
    longitude: clearSearchVal
      ? ''
      : isTrue
      ? longitudeValue
        ? longitudeValue
        : ''
      : lng
      ? lng
      : '',
    bedroom_min: clearSearchVal ? '' : isTrue ? minBedValue : minBeds,
    bedroom_max: clearSearchVal ? '' : isTrue ? maxBedValue : maxBeds,
    amenities: clearSearchVal ? '' : isTrue ? amenitiesValues : amenities,
    filter_data: saveSearch,
    subscription_tyre: object?.subscriptionSort ? object?.subscriptionSort : '',
    sort_price: object?.priceSort ? object?.priceSort : '',
    stateFilter: stateFilter,
    countryFilter: countryFilter,
    cityFilter: cityFilter,
    category: category ? category : '',
  });

  useEffect(() => {
    refetch();
  }, [stateFilter, category, countryFilter, cityFilter]);

  const token = storage.getToken();
  const [datas, setDatas] = useState([]);
  const [datasCountry, setDatasCountry] = useState([]);
  const [datasState, setDatasState] = useState([]);
  const [datasCity, setDatasCity] = useState([]);
  const axiosUrl = process.env.REACT_APP_API_URL;

  useEffect(() => {
    async function fetchData() {
      try {
        const response = await axios.get(
          `${axiosUrl}/panel-api/rent-property-list?filter_data=${saveSearch}&subscription_tyre=${
            object?.subscriptionSort ? object?.subscriptionSort : ''
          }&sort_price=${
            object?.priceSort ? object?.priceSort : ''
          }&min_price=${minPrice}&max_price=${maxPrice}&location=${location}&longitude=${
            lng ? lng : ''
          }&latitude=${
            lat ? lat : ''
          }&bedroom_min=${minBeds}&bedroom_max=${maxBeds}&amenities=${amenities}&category=${
            category ? category : ''
          }&countryFilter=${countryFilter}&stateFilter=${stateFilter}&cityFilter=${cityFilter}`
        );
        setDatas(response?.data);
      } catch (error) {
        console.error('Error fetching data:', error);
      }
    }

    fetchData();
  }, [selectedCountry, category, selectedState, selectedCity]);

  useEffect(() => {
    setDatasCountry(datas?.country_data);
    setDatasState(datas?.state_data);
    setDatasCity(datas?.city_data);
  }, [datas]);

  const [clear, setClear] = useState(false);
  const [sendObj, setSendObj] = useState({});
  const obj = {
    priceSort: object?.priceSort,
    subscriptionSort: object?.subscriptionSort,
    timeSort: object?.timeSort,
  };
  const objNew = {
    priceSort: '',
    subscriptionSort: '',
    timeSort: '',
  };
  useEffect(() => {
    refetch();
    setHeartClicked(false);
    setSaveSearch(false);
    setSendObj(obj);
  }, [heartClicked, search, saveSearch, refetch, isTrue]);

  useEffect(() => {
    if (clearSearchVal === true) {
      refetch();
      setClearSearchVal(false);
    }
  }, [clearSearchVal]);

  useEffect(() => {
    setSaveSearch(false);
    setClear(false);
    refetch();
    setSendObj(objNew);
  }, [clear]);

  // ------------------ Save search ----------------

  const handleSearchApi = async (objects: any) => {
    try {
      setLoadingSave(true);
      await saveSearchApi(objects);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have saved this request successfully!',
      });
    } finally {
      setLoadingSave(false);
      setSaveSearch(false);
      setSave(false);
    }
  };

  useEffect(() => {
    if (save === true) {
      handleSearchApi(dataToSave);
    }
  }, [save]);

  // ------------------ Save search ----------------

  return (
    <>
      <ContentLayout title={i18next.t('Property for Sale')}>
        <BackdropLoader open={loading} />
        <Header type={HeaderType.LANDING} />
        <BreadCrum
          head={i18next.t('Discover Properties for Rent')}
          line2={i18next.t('Find Your Next Place to Live')}
          pragraf={i18next.t(
            'Finding the right place to rent makes an enormous difference. Check out the options from our network for free!'
          )}
        />
        <PFSSearchForm
          setMinPrice={setMinPrice}
          setMaxPrice={setMaxPrice}
          setMinBeds={setMinBeds}
          setMaxBeds={setMaxBeds}
          setAmenities={setAmenities}
          setlocation={setlocation}
          setSearch={setSearch}
          setSave={setSave}
          setlat={setlat}
          setlng={setlng}
          setClearSearchVal={setClearSearchVal}
        />
        <br />
        <ServiceItemList
          setObject={setObject}
          setSaveSearch={setSaveSearch}
          setClear={setClear}
          newObj={sendObj}
          linkAddress={'/Propert_sale_rent?page=Propert_sale_rent'}
        />
        {/* <Carousel /> */}
        <div className="container">
          <h4>{i18next.t('Properties')}</h4>
          <div className="row">
            {listing?.length == 0 ? (
              <h4 className="makeCenter">{i18next.t('No listing found !')}</h4>
            ) : (
              <>
                {isLoading || isFetching || isRefetching || !datas ? (
                  <MyListingLoader />
                ) : (
                  <>
                    <div className="row">
                      <div className="col-md-3 col-12 col-lg-2 bg-pink">
                        <h6>{i18next.t('Country')}</h6>
                        {datasCountry?.map((countryItem, index) => (
                          <div className="mapChecks" key={index}>
                            <FormControlLabel
                              control={
                                <Checkbox
                                  checked={selectedCountry.includes(countryItem.country)}
                                  onChange={() => handleCountryCheckboxChange(countryItem.country)}
                                />
                              }
                              label={countryItem.country}
                            />
                            (<span>{countryItem?.total_properties}</span>)
                          </div>
                        ))}
                        {datasState ? datasState?.length > 0 ? <h6>State</h6> : null : null}
                        {datasState?.map((stateItem, index) => (
                          <div className="mapChecksState" key={index}>
                            <FormControlLabel
                              control={
                                <Checkbox
                                  checked={selectedState.includes(stateItem.state)}
                                  onChange={() => handleStateCheckboxChange(stateItem.state)}
                                />
                              }
                              label={stateItem.state}
                            />
                            (<span>{stateItem?.total_properties}</span>)
                          </div>
                        ))}
                        {datasCity ? datasCity?.length > 0 ? <h6>City</h6> : null : null}

                        {datasCity?.map((cityItem, index) => (
                          <div className="mapChecks" key={index}>
                            <FormControlLabel
                              control={
                                <Checkbox
                                  checked={selectedCity.includes(cityItem.city)}
                                  onChange={() => handleCityCheckboxChange(cityItem.city)}
                                />
                              }
                              label={cityItem.city}
                            />
                            (<span>{cityItem?.total_properties}</span>)
                          </div>
                        ))}
                      </div>
                      <div className="col-md-9 col-12 col-lg-10 prop-rent-col">
                        <div className="row prop-rent-row">
                          {listing?.map((item, index) => (
                            <PropertyForRentItem
                              key={index}
                              item={item}
                              deleteIcon={false}
                              headData={false}
                              editIcon={false}
                              setHeartClicked={setHeartClicked}
                              setDeleteClicked={undefined}
                            />
                          ))}
                        </div>
                      </div>
                    </div>
                  </>
                )}
              </>
            )}
          </div>
        </div>
        <br />
        <Footer />
      </ContentLayout>
    </>
  );
};
