import React, { useState } from 'react';
import clsx from 'clsx';
import DropDown from '@/components/Elements/DropDown/DropDown';

const PropertyStatus: React.FC = (): JSX.Element => {
  const [showDropDown, setShowDropDown] = useState<boolean>(false);
  const [selectCity, setSelectCity] = useState<string>('');
  const cities = () => {
    return ['All ', 'Apartment For Sale', 'Villa /House For Sale', 'Townhouse', 'Penthouse'];
  };

  const toggleDropDown = () => {
    setShowDropDown(!showDropDown);
  };

  const dismissHandler = (event: React.FocusEvent<HTMLButtonElement>): void => {
    if (event.currentTarget === event.target) {
      setShowDropDown(false);
    }
  };

  const citySelection = (city: string): void => {
    setSelectCity(city);
  };

  return (
    <div className="dd">
      <button
        className={clsx('drops', showDropDown ? 'active' : undefined)}
        onClick={(): void => toggleDropDown()}
        onBlur={(e: React.FocusEvent<HTMLButtonElement>): void => dismissHandler(e)}
      >
        <div>{selectCity ? selectCity : 'Property Type >'} </div>
        {showDropDown && (
          <DropDown
            cities={cities()}
            showDropDown={false}
            toggleDropDown={(): void => toggleDropDown()}
            citySelection={citySelection}
          />
        )}
      </button>
    </div>
  );
};

export default PropertyStatus;
