import * as React from 'react';
import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import Typography from '@mui/material/Typography';
import Box from '@mui/material/Box';
import './Tabss.css';
import ResidentialForm from '@/features/misc/routes/PropertyForSale/ResidentialForm/ResidentialForm';
import CommercialForm from '@/features/misc/routes/PropertyForSale/CommercialForm/CommercialForm';
import LandForm from '@/features/misc/routes/PropertyForSale/LandForm/LandForm';
import UnitForm from '@/features/misc/routes/PropertyForSale/UnitForm/UnitForm';

interface TabPanelProps {
  children?: React.ReactNode;
  index: number;
  value: number;
}

function TabPanel(props: TabPanelProps) {
  const { children, value, index, ...other } = props;

  return (
    <div
      role="tabpanel"
      hidden={value !== index}
      id={`simple-tabpanel-${index}`}
      aria-labelledby={`simple-tab-${index}`}
      {...other}
    >
      {value === index && (
        <Box sx={{ p: 4 }}>
          <Typography>{children}</Typography>
        </Box>
      )}
    </div>
  );
}

function a11yProps(index: number) {
  return {
    id: `simple-tab-${index}`,
    'aria-controls': `simple-tabpanel-${index}`,
  };
}

export default function Tabss() {
  const [value, setValue] = React.useState(0);

  const handleChange = (event: React.SyntheticEvent, newValue: number) => {
    setValue(newValue);
  };

  return (
    <Box sx={{ width: '100%' }}>
      <Box sx={{ borderBottom: 1, borderColor: 'divider' }}>
        <Tabs className="row" value={value} onChange={handleChange} aria-label="basic tabs example">
          <Tab className="tabx" label="Residential For Sale " {...a11yProps(0)} />
          <Tab className="tabx" label="Commercial  For Sale" {...a11yProps(1)} />
          <Tab className="tabx" label="Land  For Sale" {...a11yProps(2)} />
          <Tab className="tabx" label="Multiple Unit  For Sale" {...a11yProps(3)} />
        </Tabs>
      </Box>
      <TabPanel value={value} index={0}>
        <ResidentialForm />
      </TabPanel>
      <TabPanel value={value} index={1}>
        <CommercialForm />
      </TabPanel>
      <TabPanel value={value} index={2}>
        <LandForm />
      </TabPanel>
      <TabPanel value={value} index={3}>
        <UnitForm />
      </TabPanel>
    </Box>
  );
}
