import Loader from '@/components/Elements/Loader/Loader';
import { ContentLayout } from '@/components/Layout';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import React, { useEffect, useState } from 'react';

import { useParams, Link } from 'react-router-dom';

import { CompanyDescription } from './CompanyTabs/CompanyDescription';
import { IssuesInfo } from './CompanyTabs/IssuesInfo';
import { CompanyData } from './CompanyTabs/CompanyData';
import { DocumentsTab } from './CompanyTabs/DocumentsTab';
import { useCompanyInvestmentPannel } from '@/api/companyInvestment/companyInvestmentPannel';
import { useNotificationStore } from '@/stores/notifications';
import { buyShares } from '@/api/companyInvestment/buyShares';
import { useAuth } from '@/lib/auth';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const CompanyDetail = () => {
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { user } = useAuth();
  const customerId = user?.customer_id;
  const [CMID, setCMID] = useState();
  const [isSame, setIsSame] = useState(false);
  const [dataLoad, setDataLoad] = useState(false);
  const [isApiLoad, setLoading] = useState(false);

  const { data, isLoading, isFetching } = useCompanyInvestmentPannel({ id: id ?? '2' });
  const company = data?.data;

  useEffect(() => {
    setCMID(company?.customer_id);
  }, [company]);

  useEffect(() => {
    setDataLoad(true);
    if (CMID == customerId) {
      setIsSame(true);
    }
    setDataLoad(false);
  }, [CMID]);

  const handleSubmit = async () => {
    try {
      setLoading(true);

      await buyShares({
        company_id: `${id}`,
        url: `/company-detail/${id}?type=InvestmentCompany`,
      });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'info',
        message: 'Inquiry to Buy shares sent successfully!',
      });
    } finally {
      setLoading(false);
      localStorage.removeItem('values');
    }
  };

  return (
    <>
      {isLoading || isFetching || dataLoad ? (
        <Loader />
      ) : (
        <ContentLayout title="Company Investment Detail">
          <>
            <Header type={HeaderType.LANDING} />
            <div className="investment-company">
              <div className="container SaleContent invest-sales">
                <p className="line1 mb-1">{company?.company_name}</p>
                <p className="f-15 pb-4">{company?.company_address}</p>
                <div className="row w-100 m-auto">
                  <div className="col-12 col-md-5 col-lg-4">
                    <div className="SaleContent pt-0">
                      <div className="line5 mt-3">
                        <div className="valuation-row">
                          <div className="valuation-col border-right">
                            <p className="mb-0">No Share Before Issue</p>
                            <p className="mb-0">{company?.no_share_bfr_issue}</p>
                          </div>

                          <div className="valuation-col  border-right">
                            <p className="mb-0">Nominal Share Price</p>
                            <p className="mb-0">
                              {localSymbol}
                              {(company?.nominal_share_price * localCurrency)?.toFixed(0) ?? ''}
                            </p>
                          </div>
                          <div className="valuation-col  border-right">
                            <p className="mb-0">Shares for Sale</p>
                            <p className="mb-0">{company?.shares_for_sale}</p>
                          </div>
                        </div>
                        <div className="sl1 row">
                          <p className="left col-6 col-md-6">The valuation</p>
                          <p className="right col-6 col-md-6">
                            {localSymbol}{' '}
                            {(company?.the_valuation * localCurrency)?.toFixed(0) ?? ''}
                          </p>
                        </div>

                        <div className="sl1 row">
                          <p className="left col-6 col-md-6">{i18next.t('Remaining shares')}</p>
                          <p className="right col-6 col-md-6">
                            {localSymbol}{' '}
                            {(company?.remaninig_shares * localCurrency)?.toFixed(0) ?? ''}
                          </p>
                        </div>
                        <div className="sl1 row">
                          <p className="left col-6 col-md-6">{i18next.t('Minimum drawing')}</p>
                          <p className="right col-6 col-md-6">
                            {localSymbol}{' '}
                            {(company?.minimum_drawing * localCurrency).toFixed(0) ?? ''}
                          </p>
                        </div>
                        <div className="sl1 row">
                          <p className="left col-6 col-md-6">{i18next.t('Maximum drawing')}</p>
                          <p className="right col-6 col-md-6">
                            {localSymbol} {(company?.max_drawing * localCurrency)?.toFixed(0) ?? ''}
                          </p>
                        </div>
                      </div>
                      {isSame === true ? (
                        <div className="buy-shares d-flex align-items-start gap-2">
                          <button className="btn btn-primary" disabled={true}>
                            {i18next.t('Buy Shares')}
                          </button>
                          <p className="f-13 mb-0">
                            {i18next.t(
                              'You are the owner of this Business , Not allowed to buy shares'
                            )}
                          </p>
                        </div>
                      ) : (
                        <div className="buy-shares d-flex align-items-start gap-2">
                          <button
                            className="btn btn-primary"
                            onClick={() => handleSubmit()}
                            disabled={isApiLoad}
                          >
                            {i18next.t('Buy Shares')}
                          </button>
                          <p className="f-13 mb-0">
                            {i18next.t(
                              'Before buying shares, you should understand the risks involved. Don t invest more than you can afford to lose.'
                            )}
                          </p>
                        </div>
                      )}
                    </div>
                  </div>
                  <div className="col-12 col-md-7 col-lg-8">
                    <div className="row">
                      <div className="col-12 col-md-6 col-lg-6 no-space">
                        <div className="full-image dpImage">
                          {eval(company?.image_data)
                            .slice(0, 1)
                            .map((item: any, index: number) => (
                              <div className="dp-full h-100" key={index}>
                                <img
                                  className="idImage busines-top-img"
                                  alt="hixas"
                                  src={item?.image}
                                />
                              </div>
                            ))}
                        </div>
                      </div>
                      <div className="col-12 col-md-6 col-lg-6 no-space">
                        <div className="invest-half-image">
                          {eval(company?.image_data)
                            .slice(1, 2)
                            .map((item: any, index: number) => (
                              <img
                                key={index}
                                className="half-invest-img"
                                alt="hixas"
                                src={item?.image}
                              />
                            ))}
                          {eval(company?.image_data)
                            .slice(2, 3)
                            .map((item: any, index: number) => (
                              <img
                                key={index}
                                className="half-invest-img"
                                alt="hixas"
                                src={item?.image}
                              />
                            ))}
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="social-list container">
                  {i18next.t('Share the campaign with your friends')}:
                  <Link to="/">
                    <i className="fa-regular fa-envelope"></i>
                  </Link>
                  <Link to="/">
                    <i className="fa-brands fa-twitter"></i>
                  </Link>
                  <Link to="/">
                    <i className="fa-brands fa-linkedin"></i>
                  </Link>
                  <Link to="/">
                    <i className="fa-brands fa-whatsapp"></i>
                  </Link>
                </div>
                {/* vertical tabs */}
                <div className="company-categories mt-5 pt-3 mb-4">
                  <div className="row">
                    <div className="col-12 col-md-4 col-lg-3">
                      <h5 className="underlined-title f-26 semi-bold mb-4">
                        {i18next.t('Categories')}
                      </h5>
                      <div
                        className="nav flex-column nav-pills me-3"
                        id="v-pills-tab"
                        role="tablist"
                        aria-orientation="vertical"
                      >
                        <button
                          className="nav-link active"
                          id="v-pills-descript-tab"
                          data-bs-toggle="pill"
                          data-bs-target="#v-pills-descript"
                          type="button"
                          role="tab"
                          aria-controls="v-pills-descript"
                          aria-selected="true"
                        >
                          {i18next.t('Description')}
                        </button>
                        <button
                          className="nav-link"
                          id="v-pills-emission-tab"
                          data-bs-toggle="pill"
                          data-bs-target="#v-pills-emission"
                          type="button"
                          role="tab"
                          aria-controls="v-pills-emission"
                          aria-selected="false"
                        >
                          {i18next.t('Emission')}
                        </button>
                        <button
                          className="nav-link"
                          id="v-pills-company-tab"
                          data-bs-toggle="pill"
                          data-bs-target="#v-pills-company"
                          type="button"
                          role="tab"
                          aria-controls="v-pills-company"
                          aria-selected="false"
                        >
                          {i18next.t('Company')}
                        </button>
                        <button
                          className="nav-link"
                          id="v-pills-doc-tab"
                          data-bs-toggle="pill"
                          data-bs-target="#v-pills-doc"
                          type="button"
                          role="tab"
                          aria-controls="v-pills-doc"
                          aria-selected="false"
                        >
                          {i18next.t('Documents')}
                        </button>
                      </div>
                    </div>
                    <div className="col-12 col-md-8 col-lg-9">
                      <div className="tab-content" id="v-pills-tabContent">
                        {/* First tab descript */}
                        <div
                          className="tab-pane fade show active"
                          id="v-pills-descript"
                          role="tabpanel"
                          aria-labelledby="v-pills-descript-tab"
                        >
                          <CompanyDescription data={company} />
                        </div>

                        <div
                          className="tab-pane fade"
                          id="v-pills-emission"
                          role="tabpanel"
                          aria-labelledby="v-pills-emission-tab"
                        >
                          <IssuesInfo data={company} />
                        </div>

                        <div
                          className="tab-pane fade"
                          id="v-pills-company"
                          role="tabpanel"
                          aria-labelledby="v-pills-company-tab"
                        >
                          <CompanyData data={company} />
                        </div>
                        <div
                          className="tab-pane fade"
                          id="v-pills-doc"
                          role="tabpanel"
                          aria-labelledby="v-pills-doc-tab"
                        >
                          <DocumentsTab data={company} />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </>
        </ContentLayout>
      )}
    </>
  );
};
