import React, { useEffect, useState } from 'react';
import '../InvestmentDetail.css';

import linked from '@/assets/linkdin.png';
import { Button, Table, Dialog } from '@/components/Elements';
import i18next from 'i18next';

export const CompanyData = (data: any) => {
  const company = data?.data;
  const share = company?.shareholders;
  const [sharesData, setShares] = useState<any>();

  useEffect(() => {
    setShares(eval(share));
  }, [share]);

  const changePage = (_pageNumber) => {};

  const [teadmData, setTeamData] = useState();

  useEffect(() => {
    setTeamData(eval(company?.team));
  }, [company]);

  const [isOpen, setIsOpen] = useState(false);
  const [selectedItem, setSelectedItem] = useState(null);

  const openDialog = (item: any) => {
    setSelectedItem(item);
    setIsOpen(true);
  };
  const closeDialog = () => {
    setIsOpen(false);
  };

  // ====================== Set Partner data ++++++++++++++++++++++?

  const [partnerData, setPartnerData] = useState();

  useEffect(() => {
    setPartnerData(eval(company?.partners));
  }, [company]);

  const [isOpen2, setIsOpen2] = useState(false);
  const [partnerItem, setPartnerItem] = useState(null);

  const openDialog2 = (item: any) => {
    setPartnerItem(item);
    setIsOpen2(true);
  };
  const closeDialog2 = () => {
    setIsOpen2(false);
  };

  return (
    <>
      {company && sharesData ? (
        <div className="bakery pt-0">
          <h5>{i18next.t('The company')}</h5>
          <p className="semi-bold f-15 mb-0">{company?.company_name}</p>
          <p className="semi-bold f-15 mb-0">{company?.company_address}</p>
          <p className="semi-bold f-15 mb-0">
            {i18next.t('Estblished in')} : {company?.company_established}
          </p>
          <p className="semi-bold f-15 mb-0">
            {i18next.t('Postcode')} : {company?.company_postcode}
          </p>
          <p className="semi-bold f-15 mb-0">
            {i18next.t('Organization number')}: {company?.company_telephone}
          </p>
          <p className="semi-bold f-15 mb-0">
            {i18next.t('Chairman Email')}: {company?.chairman_email}
          </p>
          <p className="semi-bold f-15 mb-0">
            {i18next.t('Email')}: {company?.company_email}
          </p>
          <p className=" mb-0">
            {' '}
            <button
              className="semi-bold f-15 mb-0"
              onClick={() => window.open(`${company?.company_websitel}`)}
            >
              {i18next.t('Website')}
            </button>
          </p>
          <p className=" mb-0">
            <button
              className="semi-bold f-15 mb-0"
              onClick={() => window.open(`${company?.youtube_url}`)}
            >
              {i18next.t('Youtube')}
            </button>
          </p>{' '}
          <h5 className="mt-5">{i18next.t('Owners')} </h5>
          <Table
            className="bg-light-blue"
            changePage={changePage}
            total={sharesData.length}
            data={sharesData}
            columns={[
              {
                title: `${i18next.t('Name')}`,
                field: 'name',
              },
              {
                title: `${i18next.t('Stock')}`,
                field: 'stock',
              },
            ]}
          />
          <p className="f-26 bold ls-1">{i18next.t('Our Team')}</p>
          <p>{company?.self_report}</p>
          <div className="row inquire-abt team-company">
            {teadmData?.map((item: any, index: number) => (
              <div className="col-12 col-md-4 col-lg-4 no-space" key={index}>
                <div className="inquiry-ads mb-3 relative">
                  <button onClick={() => openDialog(item)}>
                    <img src={item?.image} className="inq-icon" alt="" />
                    <div className="inqury-hover">
                      <p className="f-13 semi-bold mb-0">
                        <span className="dark-color d-block">{item?.name} </span>
                      </p>
                    </div>
                  </button>
                </div>
              </div>
            ))}
            <h4 className="no-space">{i18next.t('Partners Data')}</h4>
            {partnerData?.map((item: any, index: number) => (
              <div className="col-12 col-md-4 col-lg-4 no-space" key={index}>
                <div className="inquiry-ads mb-3 relative">
                  <button onClick={() => openDialog2(item)}>
                    <img src={item?.image} className="inq-icon" alt="" />
                    <div className="inqury-hover">
                      <p className="f-13 semi-bold mb-0">
                        <span className="dark-color d-block">{item?.name} </span>
                      </p>
                    </div>
                  </button>
                </div>
              </div>
            ))}

            <Dialog isOpen={isOpen} onClose={closeDialog}>
              {selectedItem && (
                <div className="inline-block align-top bg-white px-4 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
                  <div className="investment-modal">
                    <div className="row">
                      <div className="col-12 col-md-3">
                        <div className="modal-invest-icon">
                          <img src={selectedItem?.image} alt="" />
                        </div>
                      </div>
                      <div className="col-12 col-md-9">
                        <div className="modal-invest-des">
                          <h4 className="f-18 bold">{selectedItem?.name}</h4>
                          <p className="f-14">{selectedItem?.about}</p>
                          <button
                            className="modalBoxButn"
                            onClick={() => window.open(`${selectedItem.linkedin}`)}
                          >
                            <img src={linked} alt="" />{' '}
                          </button>
                        </div>
                      </div>
                    </div>
                    <div className="mt-2 text-center w-100">
                      <Button type="button" className="m-auto" onClick={closeDialog}>
                        {i18next.t('Ok')}
                      </Button>
                    </div>
                  </div>
                </div>
              )}
            </Dialog>

            <Dialog isOpen={isOpen2} onClose={closeDialog2}>
              {partnerItem && (
                <div className="inline-block align-top bg-white px-4 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
                  <div className="investment-modal">
                    <div className="row">
                      <div className="col-12 col-md-3">
                        <div className="modal-invest-icon">
                          <img src={partnerItem?.image} alt="" />
                        </div>
                      </div>
                      <div className="col-12 col-md-9">
                        <div className="modal-invest-des">
                          <h4 className="f-18 bold">{partnerItem?.name}</h4>
                          <p className="f-14">{partnerItem?.about}</p>
                          <button
                            className="modalBoxButn"
                            onClick={() => window.open(`${partnerItem.linkedin}`)}
                          >
                            <img src={linked} alt="" />{' '}
                          </button>
                        </div>
                      </div>
                    </div>
                    <div className="mt-2 text-center w-100">
                      <Button type="button" className="m-auto" onClick={closeDialog2}>
                        {i18next.t('Ok')}
                      </Button>
                    </div>
                  </div>
                </div>
              )}
            </Dialog>
          </div>
        </div>
      ) : (
        <p>Loading</p>
      )}
    </>
  );
};
