import React, { useEffect, useState } from 'react';
import '../InvestmentDetail.css';
import FileViewer from '@/components/Viewer/FileViewer';
import { Button, Dialog } from '@/components/Elements';
import linked from '@/assets/linkdin.png';
import i18next from 'i18next';

export const CompanyDescription = (data: any) => {
  const company = data?.data;
  const [teadmData, setTeamData] = useState();

  useEffect(() => {
    setTeamData(eval(company?.board));
  }, [company]);

  const [isOpen, setIsOpen] = useState(false);
  const [selectedItem, setSelectedItem] = useState(null);

  const openDialog = (item: any) => {
    setSelectedItem(item);
    setIsOpen(true);
  };
  const closeDialog = () => {
    setIsOpen(false);
  };
  const vid = data?.data?.video;

  return (
    <>
      {company ? (
        <div className="bakery pt-0">
          <h5>{i18next.t('Company Details')}</h5>
          <p>{company?.description}</p>
          <FileViewer file={vid}></FileViewer>
          <p className="f-26 bold ls-1 mt-3">{i18next.t('Board Members')}</p>
          <p>
            {i18next.t(
              'The board at Ekeby Gårdsbryggeri has broad experience, and they have expertise from other breweries, branding and new establishments and innovation. We have three employees today. Finn-Erik Blakstad is the general manager. He is responsible for the store, sales and marketing, but also contributes to production.'
            )}
          </p>
          <div className="row inquire-abt team-company">
            {teadmData?.map((item: any, index: number) => (
              <div className="col-12 col-md-4 col-lg-4 no-space" key={index}>
                <div className="inquiry-ads mb-3 relative">
                  <button onClick={() => openDialog(item)}>
                    <img src={item?.image} className="inq-icon" alt="" />
                    <div className="inqury-hover">
                      <p className="f-13 semi-bold mb-0">
                        <span className="dark-color d-block">{item?.name} </span>
                      </p>
                    </div>
                  </button>
                </div>
              </div>
            ))}
          </div>

          <Dialog isOpen={isOpen} onClose={closeDialog}>
            {selectedItem && (
              <div className="inline-block align-top bg-white px-4 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
                <div className="investment-modal">
                  <div className="row">
                    <div className="col-12 col-md-3">
                      <div className="modal-invest-icon">
                        <img src={selectedItem?.image} alt="" />
                      </div>
                    </div>
                    <div className="col-12 col-md-9">
                      <div className="modal-invest-des">
                        <h4 className="f-18 bold">{selectedItem?.name}</h4>
                        <p className="f-14">{selectedItem?.about}</p>
                        <button
                          className="modalBoxButn"
                          onClick={() => window.open(`${selectedItem.linkedin}`)}
                        >
                          <img src={linked} alt="" />{' '}
                        </button>
                      </div>
                    </div>
                  </div>
                  <div className="mt-2 text-center w-100">
                    <Button type="button" className="m-auto" onClick={closeDialog}>
                      OK
                    </Button>
                  </div>
                </div>
              </div>
            )}
          </Dialog>
        </div>
      ) : (
        <h1>Loadings............</h1>
      )}
    </>
  );
};
