import storage from '@/utils/storage';
import '../InvestmentDetail.css';
import i18next from 'i18next';

export const IssuesInfo = (data: any) => {
  const company = data?.data;
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();

  return (
    <>
      <div className="bakery pt-0">
        <h5> {i18next.t('Issue info')}</h5>
        <div className="bg-light-pink issues-table">
          <div className="issues-start-date">
            <div className="issues-col">
              <p className="f-15 mb-0">{i18next.t('Issue account no')}:</p>
              <p className="f-13 mb-0">{company?.issue_account_no}</p>
            </div>
            <div className="issues-col">
              <p className="f-15 mb-0">{i18next.t('Bank Account Created')}:</p>
              <p className="f-13 mb-0">{company?.bank_acc_created}</p>
            </div>
            <div className="issues-col">
              <p className="f-15 mb-0">{i18next.t('Number of Share')}:</p>
              <p className="f-13 mb-0">{company?.no_share_bfr_issue}</p>
            </div>
            <div className="issues-col">
              <p className="f-15 mb-0">{i18next.t('Price per share')} :</p>
              <p className="f-13 mb-0">
                {localSymbol} {(company?.nominal_share_price * localCurrency)?.toFixed(0) ?? ''}
              </p>
            </div>
            <div className="issues-col">
              <p className="f-15 mb-0">{i18next.t('Minimum investment')} :</p>
              <p className="f-13 mb-0">
                {localSymbol} {(company?.minimum_drawing * localCurrency)?.toFixed(0) ?? ''}
              </p>
            </div>
            <div className="issues-col">
              <p className="f-15 mb-0">{i18next.t('Maximum investment')} :</p>
              <p className="f-13 mb-0">
                {localSymbol} {(company?.max_drawing * localCurrency)?.toFixed(0) ?? ''}
              </p>
            </div>
          </div>
        </div>
        <p className="f-26 bold ls-1 mt-3">{i18next.t('Self-report')}</p>
        <p>{company?.self_report}</p>
      </div>
    </>
  );
};
