import Footer from '@/components/Layout/Footer/Footer';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import React, { useEffect, useState } from 'react';
import * as z from 'zod';
import './InvestmentDetail.css';
import { useNavigate, useParams, Link } from 'react-router-dom';
import { ContentLayout } from '@/components/Layout';
import { usePropertyInvestmentDetails } from '@/api/propertyInvestment/propertyInvestmentDetailsPanel';
import Loader from '@/components/Elements/Loader/Loader';
import FileViewer from '@/components/Viewer/FileViewer';
import 'react-responsive-tabs/styles.css';
import destination from '@/assets/destination.png';
import rental from '@/assets/rental.png';

import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';

import ads from '@/assets/ads.png';
import cashFlow from '@/assets/cashFlow.png';
import user from '@/assets/man-new.jpg';
import cost from '@/assets/cost.png';
import { Dialog } from '@/components/Elements';
import linked from '@/assets/linkdin.png';

import OwlCarousel from 'react-owl-carousel';
import 'owl.carousel/dist/assets/owl.carousel.css';
import 'owl.carousel/dist/assets/owl.theme.default.css';
import { Form, InputField, TextAreaField } from '@/components/Form';
import { Button } from '@/components/Elements/Button';
import { trimThirty } from '@/utils/format';
import intro1 from '@/assets/intro1.jpg';
import FsLightbox from 'fslightbox-react';
import storage from '@/utils/storage';
import { translateAmenties } from '@/translations/translateFunction';
import i18next from 'i18next';

export const InvestmentDetail = () => {
  const navigate = useNavigate();
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { data, isLoading, isFetching } = usePropertyInvestmentDetails({ id: id ?? '2' });
  const business = data?.data;
  const [fCap, setFCap] = useState();
  const [glance, setGlance] = useState();
  useEffect(() => {
    if (business?.financial_cap_stack) {
      setFCap(JSON.parse(business?.financial_cap_stack));
    }
    if (business?.property_at_glance) {
      setGlance(JSON.parse(business?.property_at_glance));
    }
  }, [business?.financial_cap_stack, business?.property_at_glance]);

  const totalCp = parseInt(fCap?.debtPrice) + parseInt(fCap?.equityPrice);
  const equityPer = (parseInt(fCap?.equityPrice) * 100) / totalCp;
  const debtPer = (parseInt(fCap?.debtPrice) * 100) / totalCp;

  const customerId = business?.customer_id;

  const [isOpen, setIsOpen] = useState(false);
  const [selectedItem, setSelectedItem] = useState(null);
  const [toggler, setToggler] = useState<boolean>(false);
  const [pictures, setPictures] = useState([]);
  const [productIndex, setProductIndex] = useState(0);

  const openDialog = (item: any) => {
    setSelectedItem(item);
    setIsOpen(true);
  };
  const closeDialog = () => {
    setIsOpen(false);
  };

  const [pics, setPics] = useState<any>();

  useEffect(() => {
    try {
      const picsArray = eval(business?.partner);

      if (picsArray && picsArray.length > 0) {
        setPics(picsArray);
      }
    } catch (error) {
      console.error('Error evaluating image_data:', error);
    }
  }, [business?.partner]);

  const schema = z.object({
    telephone: z.custom(isValidMobile, isValidMobileMsg),

    message: z.string().min(1, 'Please enter a message'),
    email: z
      .string()
      .min(1, 'Please enter email address')
      .email('Please enter valid email address!'),
  });

  type inquiryAd = {
    telephone: string;
    message: string;
    email: string;
  };
  const presidents = [
    {
      name: `${i18next.t('OverView')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.overview}` }} />
        </>
      ),
    },

    {
      name: `${i18next.t('Investment Strategy')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <p> {business?.investment_strategy}</p>
        </>
      ),
    },
    {
      name: `${i18next.t('Business Plan')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />

          <p> {business?.business_plan}</p>
        </>
      ),
    },
    {
      name: `${i18next.t('Property Summary')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.property_summary}` }} />
        </>
      ),
    },

    {
      name: `${i18next.t('Financial Debt Assumption')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.financial_debt_assumption}` }} />
        </>
      ),
    },

    {
      name: `${i18next.t('Property Detail')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.property_detail}` }} />
        </>
      ),
    },

    {
      name: `${i18next.t('Overview')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.overview}` }} />
        </>
      ),
    },

    {
      name: `${i18next.t('Property Location')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.property_location}` }} />
        </>
      ),
    },
    {
      name: `${i18next.t('Property At Glance')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          {glance?.map((item, index) => (
            <div className="row glanceRow" key={index}>
              <div className="col-md-3 col-3 leftdd">{item?.item}</div>
              <div className="col-md-9 col-9">{item?.data}</div>
            </div>
          ))}
        </>
      ),
    },
    {
      name: `${i18next.t('Management')}`,
      biography: (
        <>
          <img className="propImages" src={business?.management_logo} alt="sds" />
          <div className="management-details">
            <p className="bold f-32 ls-1 mb-1">{i18next.t('About')}</p>
            <p>{business?.about_management}</p>
            <div className="row inquire-abt ">
              {pics?.map((item: any, index: number) => (
                <div className="col-12 col-md-4 col-lg-3" key={index}>
                  <div className="inquiry-ads mb-3 relative">
                    <button onClick={() => openDialog(item)}>
                      <img src={item.image} alt="" />
                      <div className="inqury-hover">
                        <p className="f-13 semi-bold mb-0">
                          <span className="dark-color d-block">{item?.name} </span>
                          <span>{trimThirty(item?.about)}</span>
                        </p>
                        <p className="mb-0 linked-icon">
                          <button onClick={() => window.open(`${user?.linkedin_url}`)}>
                            <img src={linked} alt="" />{' '}
                          </button>
                        </p>
                      </div>
                    </button>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </>
      ),
    },
    {
      name: `${i18next.t('Business Plan')}`,
      biography: (
        <>
          <img className="propImages" src={rental} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.business_plan}` }} />
        </>
      ),
    },
    {
      name: `${i18next.t('Property')}`,
      biography: (
        <>
          <img className="propImages" src={rental} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.business_plan}` }} />
        </>
      ),
    },
    {
      name: `${i18next.t('Disclaimers')}`,
      biography: (
        <>
          <img className="propImages" src={cashFlow} alt="sds" />
          <span dangerouslySetInnerHTML={{ __html: `${business?.disclaimers}` }} />,
        </>
      ),
    },
    {
      name: `${i18next.t('Financials')}`,
      biography: (
        <>
          <div className="financial-tab-cont">
            <p className="bold f-26 ls-1 mb-1">Cap Stack</p>
            <div className="cap-stacks border mb-3">
              <div className="row equalty-contain">
                <div className="col-12 col-md-4">
                  <div className="stack-percent bg-dark-pink text-white">
                    <p className="f-20 semi-bold mb-0">{equityPer.toFixed(0)}%</p>
                  </div>
                </div>

                <div className="col-12 col-md-8">
                  <div className="per-equality">
                    <p className="bold f-16 mb-1">
                      Equlity: {localSymbol} {(fCap?.equityPrice * localCurrency)?.toFixed(0) ?? ''}
                    </p>
                    <p className="f-13 mb-0">{fCap?.lpEquityPercent}% LP investor Equality</p>
                    <p className="f-13 mb-1">
                      {' '}
                      {localSymbol}{' '}
                      {(
                        fCap?.equityPrice *
                        (fCap?.lpEquityPercent / 1000) *
                        localCurrency
                      )?.toFixed(0) ?? ''}
                    </p>
                    <p className="f-13 mb-0">
                      {' '}
                      {fCap?.gpEquityPercent}% {i18next.t('Gp investor Equity')}
                    </p>
                    <p className="f-13 mb-0">
                      {localSymbol}{' '}
                      {(fCap?.equityPrice * (fCap?.gpEquityPercent / 1000) * localCurrency).toFixed(
                        2
                      ) ?? ''}
                    </p>
                  </div>
                </div>
              </div>
            </div>
            <div className="cap-stacks border">
              <div className="row equalty-contain">
                <div className="col-12 col-md-4">
                  <div className="stack-percent bg-dark-pink text-white">
                    <p className="f-20 semi-bold mb-0">{debtPer.toFixed(0)}%</p>
                  </div>
                </div>
                <div className="col-12 col-md-8">
                  <div className="per-equality">
                    <p className="bold f-16 mb-1">
                      {i18next.t('Debt')}
                      {localSymbol}: {(fCap?.debtPrice * localCurrency)?.toFixed(0)}
                    </p>
                    <p className="f-13 mb-0">
                      {fCap?.debtPercent}% {i18next.t('Debt')}
                    </p>
                    <p className="f-13 mb-0">
                      {localSymbol}{' '}
                      {(fCap?.debtPrice * (fCap?.debtPercent / 100) * localCurrency)?.toFixed(0) ??
                        ''}
                    </p>
                  </div>
                </div>
              </div>
            </div>

            <div className="cap-stacks text-center pt-0">
              <hr />
              <p className="f-20 mb-0 bold">
                Total : {localSymbol} {totalCp * localCurrency}
              </p>
            </div>
          </div>
        </>
      ),
    },
    {
      name: `${i18next.t('Document')}`,
      biography: (
        <>
          <img className="propImages" src={cost} alt="sds" />{' '}
          <span dangerouslySetInnerHTML={{ __html: `${business?.investment_strategy}` }} />
        </>
      ),
    },
  ];
  const optionsCar = {
    margin: 30,
    responsiveClass: true,
    nav: true,
    dots: false,
    autoplay: true,
    navText: ['<', '>'],
    rewind: true,
    smartSpeed: 1000,
    responsive: {
      0: {
        items: 2,
      },
      400: {
        items: 3,
      },
      600: {
        items: 4,
      },
      700: {
        items: 5,
      },
      1000: {
        items: 5,
      },
    },
  };
  function getTabs() {
    return presidents.map((president, index) => ({
      title: president.name,
      getContent: () => president.biography,
      key: index,
      tabClassName: 'tab',
      panelClassName: 'panel',
    }));
  }

  useEffect(() => {
    eval(business?.image_data)?.map((val) => {
      setPictures((item) => [...item, val?.image]);
    });
  }, [isLoading, isFetching]);

  const handleToggler = (index: number) => {
    setToggler((val) => !val);
    setProductIndex(index);
  };

  return (
    <>
      {isLoading || isFetching ? (
        <Loader />
      ) : (
        <ContentLayout title="Sale Detail">
          <div>
            <Header type={HeaderType.LANDING} />
            <button onClick={() => navigate(-1)}>
              <i className="fa-regular fa-circle-left go-back-button"></i>
            </button>
            <div className="container SaleContent invest-sales">
              <div className="row w-100 m-auto">
                <div className="col-12 col-md-5 col-lg-4">
                  <p className="line1">{business?.project_name}</p>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Target IRR')}, </span>
                    <span className="f-15 semi-bold">{business?.target_irr ?? ''}</span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Target Return on Cost')}*</span>
                    <span className="f-15 semi-bold">
                      {localSymbol}{' '}
                      {(business?.target_return_on_cost * localCurrency)?.toFixed(0) ?? ''}
                    </span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Target Equity Multiple')}*</span>
                    <span className="f-15 semi-bold">{business?.target_equity_multiple ?? ''}</span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Estimated Hold Period')}*</span>
                    <span className="f-15 semi-bold">{business?.estimated_hold_period ?? ''}</span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Funded')}*</span>
                    <span className="f-15 semi-bold">{business?.funded}</span>
                  </div>

                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Investment Type')}*</span>
                    <span className="f-15 semi-bold">{business?.investment_type}</span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">
                      {i18next.t('Estimated First Distribution')}*
                    </span>
                    <span className="f-15 semi-bold">
                      {localSymbol}{' '}
                      {(business?.estimated_first_distribution * localCurrency)?.toFixed(0) ?? ''}
                    </span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Minimum Investment')}*</span>
                    <span className="f-15 semi-bold">
                      {localSymbol}{' '}
                      {(business?.minimum_investment * localCurrency)?.toFixed(0) ?? ''}
                    </span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Investment Highlights')}*</span>
                    <span className="f-15 semi-bold">{business?.investment_highlights}</span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Asset Quality')}*</span>
                    <span className="f-15 semi-bold">{business?.asset_quality}</span>
                  </div>
                  <div className="invest-listing">
                    <span className="f-15 semi-bold">{i18next.t('Property Type')}*</span>
                    <span className="f-15 semi-bold">{business?.property_type}</span>
                  </div>
                </div>

                <div className="col-12 col-md-7 col-lg-8 side-img">
                  <div className="row">
                    <div className="col-12">
                      <div className="investment-top-img relative">
                        <FileViewer file={business?.videos ?? ''} />
                        <p className="f-18 semi-bold webinar-pr">{i18next.t('Project Webinar')}</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div className="social-list container">
                {i18next.t('Share the campaign with your friends')}:
                <Link to="/${business?.company_email??''}">
                  <i className="fa-regular fa-envelope"></i>
                </Link>
                <Link to="/${business?.company_twitter_link??''}">
                  <i className="fa-brands fa-twitter"></i>
                </Link>
                <Link to="/${business?.company_linkedin_link ?? ''}">
                  <i className="fa-brands fa-linkedin"></i>
                </Link>
                <Link to="/${business?.company_youtube_link??''}">
                  <i className="fa-brands fa-whatsapp"></i>
                </Link>
              </div>
              <div className="row w-100 m-auto">
                <div className="col-md-12 col-12 row picsfor fiveBOxes">
                  <OwlCarousel {...optionsCar} className="owl-theme" loop nav>
                    {eval(business?.image_data).map((item: any, index: number) => (
                      <div key={index}>
                        <div className="item">
                          {item?.name && <span className="imageNames">{item?.name}</span>}
                          <img
                            className="hiasImage"
                            alt="hias"
                            src={item?.image}
                            onClick={() => handleToggler(index)}
                          />
                        </div>
                      </div>
                    ))}
                  </OwlCarousel>
                </div>
                <FsLightbox toggler={toggler} sources={pictures} sourceIndex={productIndex} />
              </div>
            </div>
            {/* <Outlets /> */}
            <div className="oulets main-from mt-5 bg-light-pink">
              <div className="container">
                <div className="row">
                  <div className="col-md-12">
                    <div className="property-details-tabs container">
                      {/* vertical tabs */}
                      <div className="company-categories mt-3 mb-5 pt-3">
                        <div className="row">
                          <div className="col-12 col-md-4 col-lg-3">
                            <div
                              className="nav flex-column nav-pills me-3"
                              id="v-pills-tab"
                              role="tablist"
                              aria-orientation="vertical"
                            >
                              <button
                                className="nav-link active"
                                id="v-pills-descript-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-descript"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-descript"
                                aria-selected="true"
                              >
                                {i18next.t('OverView')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-invest-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-invest"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-invest"
                                aria-selected="false"
                              >
                                {i18next.t('Investment Strategy')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-plans-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-plans"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-plans"
                                aria-selected="false"
                              >
                                {i18next.t('Business Plan')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-summary-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-summary"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-summary"
                                aria-selected="false"
                              >
                                {i18next.t('Property Summary')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-debt-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-debt"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-debt"
                                aria-selected="false"
                              >
                                {i18next.t('Financial Debt Assumption')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-property-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-property"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-property"
                                aria-selected="false"
                              >
                                {i18next.t('Property Detail')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-location-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-location"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-location"
                                aria-selected="false"
                              >
                                {i18next.t('Property Location')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-glance-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-glance"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-glance"
                                aria-selected="false"
                              >
                                {i18next.t('Property At Glance')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-manage-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-manage"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-manage"
                                aria-selected="false"
                              >
                                {i18next.t('Management')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-business-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-business"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-business"
                                aria-selected="false"
                              >
                                {i18next.t('Property')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-disclaimers-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-disclaimers"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-disclaimers"
                                aria-selected="false"
                              >
                                {i18next.t('Disclaimers')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-financials-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-financials"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-financials"
                                aria-selected="false"
                              >
                                {i18next.t('Financials')}
                              </button>
                              <button
                                className="nav-link"
                                id="v-pills-doc-tab"
                                data-bs-toggle="pill"
                                data-bs-target="#v-pills-doc"
                                type="button"
                                role="tab"
                                aria-controls="v-pills-doc"
                                aria-selected="false"
                              >
                                {i18next.t('Document')}
                              </button>
                            </div>
                          </div>
                          <div className="col-12 col-md-8 col-lg-9">
                            <div className="tab-content" id="v-pills-tabContent">
                              {/* First tab descript */}
                              <div
                                className="tab-pane fade show active"
                                id="v-pills-descript"
                                role="tabpanel"
                                aria-labelledby="v-pills-descript-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={destination} alt="sds" />
                                  <span
                                    dangerouslySetInnerHTML={{ __html: `${business?.overview}` }}
                                  />
                                </div>
                              </div>
                              {/* First tab descript ends */}
                              {/* Second tab Emission */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-invest"
                                role="tabpanel"
                                aria-labelledby="v-pills-invest-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={destination} alt="sds" />
                                  <p> {business?.investment_strategy}</p>
                                </div>
                              </div>
                              {/* Second tab Emission  ends */}
                              {/* Third tab Company */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-plans"
                                role="tabpanel"
                                aria-labelledby="v-pills-plans-tab"
                              >
                                <div className="business-plans">
                                  <img className="propImages" src={destination} alt="sds" />
                                  <p> {business?.business_plan}</p>
                                </div>
                              </div>
                              {/* Third tab Company ends */}
                              {/* 4rth tab Sumamry */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-summary"
                                role="tabpanel"
                                aria-labelledby="v-pills-summary-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={destination} alt="sds" />
                                  <span
                                    dangerouslySetInnerHTML={{
                                      __html: `${business?.property_summary}`,
                                    }}
                                  />
                                </div>
                              </div>
                              {/* 4rth tab Sumamry  ends*/}
                              {/* 5th tab Debt */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-debt"
                                role="tabpanel"
                                aria-labelledby="v-pills-debt-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={destination} alt="sds" />
                                  <span
                                    dangerouslySetInnerHTML={{
                                      __html: `${business?.financial_debt_assumption}`,
                                    }}
                                  />
                                </div>
                              </div>
                              {/* 5th tab Debt  ends*/}
                              {/* 6th tab Property */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-property"
                                role="tabpanel"
                                aria-labelledby="v-pills-property-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={destination} alt="sds" />
                                  <span
                                    dangerouslySetInnerHTML={{
                                      __html: `${business?.property_detail}`,
                                    }}
                                  />
                                </div>
                              </div>
                              {/* 6th tab Property  ends*/}
                              {/* 7th tab Location */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-property"
                                role="tabpanel"
                                aria-labelledby="v-pills-property-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={destination} alt="sds" />
                                  <span
                                    dangerouslySetInnerHTML={{
                                      __html: `${business?.property_location}`,
                                    }}
                                  />
                                </div>
                              </div>
                              {/* 7th tab Location  ends*/}
                              {/* 8th tab Glance */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-glance"
                                role="tabpanel"
                                aria-labelledby="v-pills-glance-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={destination} alt="sds" />
                                  {glance?.map((item, index) => (
                                    <div className="row glanceRow" key={index}>
                                      <div className="col-md-3 col-3 leftdd">{item?.item}</div>
                                      <div className="col-md-9 col-9">{item?.data}</div>
                                    </div>
                                  ))}
                                </div>
                              </div>
                              {/* 8th tab Glance  ends*/}
                              {/* 9th tab management */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-manage"
                                role="tabpanel"
                                aria-labelledby="v-pills-manage-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img
                                    className="propImages"
                                    src={business?.management_logo}
                                    alt="sds"
                                  />
                                  <div className="management-details">
                                    <p className="bold f-32 ls-1 mb-1">About</p>
                                    <p>{business?.about_management}</p>
                                    <div className="row inquire-abt invest">
                                      {pics?.map((item: any, index: number) => (
                                        <div className="col-12 col-md-4 col-lg-3" key={index}>
                                          <div className="inquiry-ads mb-3 relative">
                                            <button onClick={() => openDialog(item)}>
                                              <img src={item.image} alt="" />
                                              <div className="inqury-hover">
                                                <p className="f-13 semi-bold mb-0">
                                                  <span className="dark-color d-block">
                                                    {item?.name}{' '}
                                                  </span>
                                                  <span>{trimThirty(item?.about)}</span>
                                                </p>
                                                <p className="mb-0 linked-icon">
                                                  <button
                                                    onClick={() =>
                                                      window.open(`${user?.linkedin_url}`)
                                                    }
                                                  >
                                                    <img src={linked} alt="" />{' '}
                                                  </button>
                                                </p>
                                              </div>
                                            </button>
                                          </div>
                                        </div>
                                      ))}
                                    </div>
                                  </div>
                                </div>
                              </div>
                              {/* 9th tab management  ends*/}
                              {/* 10th tab business */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-business"
                                role="tabpanel"
                                aria-labelledby="v-pills-business-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={rental} alt="sds" />
                                  <span
                                    dangerouslySetInnerHTML={{
                                      __html: `${business?.business_plan}`,
                                    }}
                                  />
                                </div>
                              </div>
                              {/* 10th tab business  ends*/}
                              {/* 11th tab Disclaimers */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-disclaimers"
                                role="tabpanel"
                                aria-labelledby="v-pills-disclaimers-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={rental} alt="sds" />
                                  <span
                                    dangerouslySetInnerHTML={{
                                      __html: `${business?.business_plan}`,
                                    }}
                                  />
                                </div>
                              </div>
                              {/* 11th tab disclaimer  ends*/}
                              {/* 12th tab Financials */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-financials"
                                role="tabpanel"
                                aria-labelledby="v-pills-financials-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <div className="financial-tab-cont">
                                    <p className="bold f-26 ls-1 mb-1"> {i18next.t('Cap Stack')}</p>
                                    <div className="cap-stacks border mb-3">
                                      <div className="row equalty-contain">
                                        <div className="col-12 col-md-4">
                                          <div className="stack-percent bg-dark-pink text-white">
                                            <p className="f-20 semi-bold mb-0">
                                              {equityPer.toFixed(0)}%
                                            </p>
                                          </div>
                                        </div>

                                        <div className="col-12 col-md-8">
                                          <div className="per-equality">
                                            <p className="bold f-16 mb-1">
                                              {i18next.t('Equity')}: {localSymbol}{' '}
                                              {(fCap?.equityPrice * localCurrency)?.toFixed(0) ??
                                                ''}
                                            </p>
                                            <p className="f-13 mb-0">
                                              {fCap?.lpEquityPercent}%
                                              {i18next.t('LP investor Equality')}
                                            </p>
                                            <p className="f-13 mb-1">
                                              {localSymbol}
                                              {(
                                                fCap?.equityPrice *
                                                (fCap?.lpEquityPercent / 1000) *
                                                localCurrency
                                              )?.toFixed(0) ?? ''}
                                            </p>
                                            <p className="f-13 mb-0">
                                              {' '}
                                              {fCap?.gpEquityPercent}%{' '}
                                              {i18next.t('Gp investor Equity')}
                                            </p>
                                            <p className="f-13 mb-0">
                                              {localSymbol}{' '}
                                              {(
                                                fCap?.equityPrice *
                                                (fCap?.gpEquityPercent / 1000) *
                                                localCurrency
                                              ).toFixed(0) ?? ''}
                                            </p>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <div className="cap-stacks border">
                                      <div className="row equalty-contain">
                                        <div className="col-12 col-md-4">
                                          <div className="stack-percent bg-dark-pink text-white">
                                            <p className="f-20 semi-bold mb-0">
                                              {debtPer.toFixed(0)}%
                                            </p>
                                          </div>
                                        </div>
                                        <div className="col-12 col-md-8">
                                          <div className="per-equality">
                                            <p className="bold f-16 mb-1">
                                              {i18next.t('Debt')}: {fCap?.debtPrice}
                                            </p>
                                            <p className="f-13 mb-0">
                                              {fCap?.debtPercent}% {i18next.t('Debt')}
                                            </p>
                                            <p className="f-13 mb-0">
                                              {localSymbol}{' '}
                                              {(
                                                fCap?.debtPrice *
                                                (fCap?.debtPercent / 1000) *
                                                localCurrency
                                              ).toFixed(0) ?? ''}
                                            </p>
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div className="cap-stacks text-center pt-0">
                                      <hr />
                                      <p className="f-20 mb-0 bold">
                                        {i18next.t('Total')} : {localSymbol}{' '}
                                        {totalCp * localCurrency}
                                      </p>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              {/* 12th tab Financials  ends*/}
                              {/* 13th tab Document */}
                              <div
                                className="tab-pane fade"
                                id="v-pills-document"
                                role="tabpanel"
                                aria-labelledby="v-pills-document-tab"
                              >
                                <div className="overview-tab-cnt">
                                  <img className="propImages" src={cost} alt="sds" />{' '}
                                  <span
                                    dangerouslySetInnerHTML={{
                                      __html: `${business?.investment_strategy}`,
                                    }}
                                  />
                                </div>
                              </div>
                              {/* 13th tab Document  ends*/}
                            </div>
                            <div className="inquiry-pg-form mt-4">
                              <div className="row">
                                <div className="col-12 col-md-12 col-lg-6 propert-details">
                                  <div className="tabs-enq-form cardss iqforms">
                                    <div className="inquireformhover">
                                      <span className="titleHeader2">
                                        {i18next.t('Inquiry about the ad')}
                                      </span>
                                      <fieldset>
                                        <Form<inquiryAd> schema={schema} className="formMsg">
                                          {({ register, formState }) => (
                                            <>
                                              <InputPhone
                                                floating
                                                error={formState.errors['telephone']}
                                                registration={register('telephone')}
                                              />
                                              <InputField
                                                label={translateAmenties('Email')}
                                                error={formState.errors['email']}
                                                registration={register('email')}
                                              />
                                              <TextAreaField
                                                label={translateAmenties('Message')}
                                                error={formState.errors['message']}
                                                registration={register('message')}
                                              />
                                              <div className="iq-div">
                                                <Button type="submit" className="iq-btn dark-btn">
                                                  {translateAmenties('Inquire Now')}
                                                </Button>
                                              </div>
                                            </>
                                          )}
                                        </Form>
                                      </fieldset>
                                    </div>
                                  </div>
                                </div>
                                <div className="col-12 col-md-12 col-lg-6">
                                  <div className="ads-main-container">
                                    <img src={ads} alt="" />
                                    <div className="ads-descrpt bg-dark-pink text-white">
                                      <p className="f-13 mb-1">
                                        {i18next.t('We would not be where we are today')}.
                                      </p>
                                      <p className="f-15 semi-bold mb-0">
                                        {i18next.t('Kai Stiberg, Eagle')}
                                      </p>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <Dialog isOpen={isOpen} onClose={closeDialog}>
              {selectedItem && (
                <div className="inline-block align-top bg-white px-4 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
                  <div className="investment-modal">
                    <div className="row">
                      <div className="col-12 col-md-3">
                        <div className="profileFoto outlets">
                          <div className="mainDIv card">
                            <div className="topPics">
                              <img src={intro1} alt="picture" />
                            </div>
                            <div className="midData text-center">
                              <h5 className="f-18 mb-0">John Smith Reachel</h5>
                              <p className="f-14">{i18next.t('Reeipo Real Estate Agent')} </p>
                            </div>

                            <div className="bottomButn gap-2 flex-column">
                              <Button onClick={() => navigate(`/profile-details?id=${customerId}`)}>
                                Book a meeting
                              </Button>
                              <Button>{i18next.t('Inquire Now')}</Button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div className="col-12 col-md-3">
                        <div className="modal-invest-icon">
                          <img src={selectedItem.image} alt="" />
                        </div>
                      </div>
                      <div className="col-12 col-md-6">
                        <div className="modal-invest-des">
                          <h4 className="f-18 bold">{selectedItem.name}</h4>
                          <h5 className="f-18 semi-bold">{selectedItem.position}</h5>
                          <p className="f-14">{selectedItem?.about}</p>
                          <button
                            className="modalBoxButn"
                            onClick={() => window.open(`${selectedItem.linkedin}`)}
                          >
                            <img src={linked} alt="" />{' '}
                          </button>
                        </div>
                      </div>
                    </div>
                    <div className="mt-2 text-center w-100">
                      <Button type="button" className="m-auto" onClick={closeDialog}>
                        OK
                      </Button>
                    </div>
                  </div>
                </div>
              )}
            </Dialog>
            <Footer />
          </div>
        </ContentLayout>
      )}
    </>
  );
};
