/* eslint-disable react/jsx-key */
import React, { useEffect, useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import './landing.css';
import { usePropertyInvestment } from '@/api/propertyProject/getPropertyInvestment';
import { useCompanyInvestment } from '@/api/companyInvestment/getCompanyInvestment';

import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { ContentLayout } from '@/components/Layout';
import ForSaleBread from '@/components/Layout/ForSaleBread';
import manew from '@/assets/man-new.jpg';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import InvestmentProject from '@/features/user/components/InvestmentProject';
import lc1 from '@/assets/lc1.png';
import lc2 from '@/assets/lc2.png';
import clsx from 'clsx';
import InvestmentCompanys from '@/features/user/components/InvestmentCompanys';
import { translateAmenties } from '@/translations/translateFunction';
import i18next from 'i18next';

export const PropertyManager = () => {
  const [loading] = useState(false);
  const [heartClicked, setHeartClicked] = useState<boolean>();

  const {
    data: clisting,
    isLoading: isCLoading,
    refetch: refetchC,
  } = useCompanyInvestment({ page: '1' });
  const {
    data: listing,
    isLoading: isPLoading,
    refetch: refetchP,
  } = usePropertyInvestment({ page: '1' });
  const [tabIndex, setTabIndex] = useState(1);

  useEffect(() => {
    refetchP();
    setHeartClicked(false);
  }, [heartClicked, refetchP, refetchC]);

  const handleParams = () => {
    setTabIndex(1);
    refetchP();
  };
  const handleParamsno = () => {
    setTabIndex(2);
    refetchC();
  };
  return (
    <>
      <ContentLayout title={i18next.t('Property Developer')}>
        <BackdropLoader open={loading} />
        <Header type={HeaderType.LANDING} />

        <ForSaleBread
          head={translateAmenties('Property Developers Seeking Capital')}
          button={i18next.t('Projects for Investment')}
          buttons={i18next.t('Companies for Investment')}
          photo={manew}
          linkAddress="/user/project-money"
          propertyType="1"
        />
        <div className="container">
          <div className="saleContent container">
            <div className="row">
              <div className="boxxx col-6 col-md-6 bls text-right">
                <button
                  className={clsx('inbx', tabIndex === 1 ? 'actives' : 'nonactive')}
                  onClick={handleParams}
                >
                  <p>
                    {' '}
                    <img src={lc1} alt="largecompanies" />
                  </p>
                  <p>{translateAmenties('Projects for Investment')}</p>
                </button>
              </div>
              <div className="boxxx col-6 col-md-6 brs">
                <button
                  className={clsx('inbx', tabIndex === 2 ? 'actives' : 'nonactive')}
                  onClick={handleParamsno}
                >
                  <p>
                    <img src={lc2} alt="largecompanies" />
                  </p>
                  <p>{translateAmenties('Companies for Investment')}</p>
                </button>
              </div>
            </div>
            {tabIndex === 1 ? (
              <>
                {listing?.length == 0 ? (
                  <h4 className="makeCenter m-4">
                    {i18next.t('No project found for investment !')}
                  </h4>
                ) : (
                  <div className="row">
                    {isPLoading ? (
                      <MyListingLoader />
                    ) : (
                      <>
                        {listing?.map((item, index) => (
                          <InvestmentProject
                            headData={false}
                            editIcon={false}
                            deleteIcon={false}
                            key={index}
                            item={item}
                            setHeartClicked={setHeartClicked}
                            heartIcon={false}
                            setDeleteClicked={undefined}
                            heartFavIcon={false}
                          />
                        ))}
                      </>
                    )}
                  </div>
                )}
              </>
            ) : (
              <>
                {clisting?.length == 0 ? (
                  <h4 className="makeCenter m-4">No company found for investment !</h4>
                ) : (
                  <div className="row">
                    {isCLoading ? (
                      <MyListingLoader />
                    ) : (
                      <>
                        {clisting?.map((item, index) => (
                          <InvestmentCompanys
                            headData={false}
                            editIcon={false}
                            deleteIcon={false}
                            key={index}
                            item={item}
                            setHeartClicked={setHeartClicked}
                            heartIcon={false}
                            setDeleteClicked={undefined}
                          />
                        ))}
                      </>
                    )}
                  </div>
                )}
              </>
            )}
          </div>
        </div>
        <br />
        <Footer />
      </ContentLayout>
    </>
  );
};
