/* eslint-disable react/jsx-key */
import React, { useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import './landing.css';
import BreadCrumb from '@/components/Layout/BreadCrumb';

import Carousel from '@/features/misc/routes/Landing/Carousel/Carousel';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useLandingListing } from '@/api/landing/landingListing';
import ServiceItemList from '@/features/misc/routes/Landing/ServiceItemList';
import ServiceItem from '@/features/user/components/ServiceItem';

export const PropertyProject = () => {
  const [loading] = useState(false);
  const { data: listing, isLoading } = useLandingListing({ page: '1' });
  const [object, setObject] = useState(null);
  const [saveSearch, setSaveSearch] = useState(false);

  return (
    <>
      <BackdropLoader open={loading} />
      <Header type={HeaderType.LANDING} />
      <BreadCrumb
        head="Discover our many"
        line2="Property Projects"
        paragraph="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
            incididunt ut labore et dolore magna aliqua"
        button2="How It Works"
      />
      <br />
      <br />
      <br />
      <ServiceItemList setObject={setObject} setSaveSearch={setSaveSearch} />
      <Carousel />
      <div className="container">
        <div className="row">
          {isLoading ? (
            <MyListingLoader />
          ) : (
            <>
              {listing?.map((item, index) => (
                <ServiceItem
                  key={index}
                  item={item}
                  showEditIcon={false}
                  linkAddress={'/project_type?page=project_type'}
                />
              ))}
            </>
          )}
        </div>
      </div>
      <br />
      <Footer />
    </>
  );
};
