import React from 'react';
import OwlCarousel from 'react-owl-carousel';
import 'owl.carousel/dist/assets/owl.carousel.css';
import 'owl.carousel/dist/assets/owl.theme.default.css';
import './Carousel.css';
import { useBusinessDetails } from '@/api/commonDetail/getBusinessDetail';
import { useParams } from 'react-router-dom';

function PropertyCarousel() {
  const { id } = useParams();
  const { data } = useBusinessDetails({ id: id ?? '2' });
  const property = data?.data;
  const options = {
    margin: 30,
    responsiveClass: true,
    nav: true,
    dots: false,
    autoplay: true,
    navText: ['<', '>'],
    smartSpeed: 1000,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 1,
      },
      600: {
        items: 1,
      },
      700: {
        items: 2,
      },
      1000: {
        items: 1,
      },
    },
  };

  return (
    <>
      <div className="container">
        <div className="propertyCarousel">
          <OwlCarousel {...options} className="owl-theme" loop nav>
            <div>
              <div className="item">
                <img alt="hias" src={property?.image_one} />
              </div>
            </div>
            <div>
              <div className="item">
                <img alt="hias" src={property?.image_two} />
              </div>
            </div>
            <div>
              <div className="item">
                <img alt="hias" src={property?.image_three} />
              </div>
            </div>
            <div>
              <div className="item">
                <img alt="hias" src={property?.image_four} />
              </div>
            </div>
            <div>
              <div className="item">
                <img alt="hias" src={property?.image_five} />
              </div>
            </div>
          </OwlCarousel>
        </div>
      </div>
    </>
  );
}

export default PropertyCarousel;
